/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.doc.script;

import java.awt.Color;
import java.awt.Font;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import nlc.lib.doc.shape.DcfTextShape;

public class DcfTextShapeScriptParser {
    public static final int INIT = -1;
    public static final int NAME = 101;
    public static final int VALUE = 201;
    public static final int STRING = 301;
    protected int mode = -1;
    protected int pos = -1;
    protected StringBuilder nameBuf = new StringBuilder();
    protected StringBuilder valueBuf = new StringBuilder();
    protected DcfTextShape textShape;
    protected String fontName;
    protected int fontStyle;
    protected float fontSize;

    public void parse(DcfTextShape textShape, List<String> paramList, Map<String, String> paramMap) throws Exception {
        this.textShape = textShape;
        this.fontName = "\uff2d\uff33 \uff30\u660e\u671d";
        this.fontStyle = 0;
        this.fontSize = 8.0f;
        textShape.setWidth(BcNumberUtil.parseDouble(paramList.get(3), 0.0));
        textShape.setHeight(BcNumberUtil.parseDouble(paramList.get(4), 0.0));
        for (Map.Entry<String, String> entry : paramMap.entrySet()) {
            this.parse_L2(entry.getKey(), entry.getValue());
        }
        textShape.font = new Font(this.fontName, this.fontStyle, (int)this.fontSize);
    }

    protected void parse_L2(String key, String value) throws Exception {
        if (BcStringUtil.equals(key, "to")) {
            this.textShape.textOrientation = BcStringUtil.equals(value, "tb") ? 2 : (BcStringUtil.equals(value, "rl") ? 3 : 1);
        }
        if (BcStringUtil.equals(key, "va")) {
            this.textShape.verticalAlign = BcStringUtil.equals(value, "C") ? 0 : (BcStringUtil.equals(value, "B") ? 3 : 1);
        }
        if (BcStringUtil.equals(key, "ha")) {
            this.textShape.horizontalAlign = BcStringUtil.equals(value, "C") ? 0 : (BcStringUtil.equals(value, "R") ? 4 : 2);
        }
        if (BcStringUtil.equals(key, "w")) {
            this.textShape.wrapText = true;
        }
        if (BcStringUtil.equals(key, "fn")) {
            this.fontName = value;
        }
        if (BcStringUtil.equals(key, "fs") && !BcStringUtil.isEmpty(value)) {
            this.fontSize = BcNumberUtil.parseFloat(value).floatValue();
        }
        if (BcStringUtil.equals(key, "fb")) {
            this.fontStyle = 1;
        }
        if (BcStringUtil.equals(key, "fi")) {
            this.fontStyle += 2;
        }
        if (BcStringUtil.equals(key, "fgc")) {
            this.textShape.textColor = this.parseColor(value);
        }
        if (BcStringUtil.equals(key, "lw") && !BcStringUtil.isEmpty(value)) {
            this.textShape.lineWidth = BcNumberUtil.parseDouble(value);
        }
        if (BcStringUtil.equals(key, "lt")) {
            this.textShape.lineType = value;
        }
        if (BcStringUtil.equals(key, "lc")) {
            this.textShape.lineColor = this.parseColor(value);
        }
        if (BcStringUtil.equals(key, "\uff43")) {
            this.textShape.doClip = true;
        }
        if (BcStringUtil.equals(key, "td")) {
            BigDecimal bigDecimal = new BigDecimal(value);
            this.textShape.textDegrees = bigDecimal.doubleValue();
        }
        if (BcStringUtil.equals(key, "v")) {
            this.textShape.value = BcStringUtil.toString(BcStringUtil.escapDecode(value));
        }
    }

    protected Color parseColor(String value) throws Exception {
        if (BcStringUtil.isEmpty(value)) {
            return null;
        }
        BigInteger biR = new BigInteger(value.substring(0, 2), 16);
        BigInteger biG = new BigInteger(value.substring(2, 4), 16);
        BigInteger biB = new BigInteger(value.substring(4, 6), 16);
        return new Color(biR.intValue(), biG.intValue(), biB.intValue());
    }
}

