/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.swg;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javafx.embed.swing.JFXPanel;
import jp.co.extreme.awt.AwtImageHelper;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.scf4.fx.Y_HfxTablePropertyPane;
import jp.co.extreme.scf4.swg.HswgColumnContextTableModel;
import jp.co.extreme.scf4.swg.HswgTableColumnConfigurePanel;
import jp.co.extreme.scf4.swg.HswgTableDisplayUtil;
import jp.co.extreme.scf4.table.ScfColumnContext;
import jp.co.extreme.scf4.table.ScfDisplayContext;
import jp.co.extreme.swing.SwgDecoratePanel;
import jp.co.extreme.swing.SwgDialog;
import jp.co.extreme.swing.SwgTabbedPane;
import jp.co.extreme.swing.SwgUtil;

public class HswgTableDisplayContextPanel
extends SwgDecoratePanel {
    protected SwgTabbedPane tabbedPane = new SwgTabbedPane(1);
    protected String tagetName;
    protected List<ScfColumnContext> columnContextList;
    protected ScfDisplayContext displayContext1;
    public ScfDisplayContext displayContext2;
    protected HswgTableColumnConfigurePanel tableColumnConfigurePanel = new HswgTableColumnConfigurePanel();
    protected Y_HfxTablePropertyPane tablePropertyPane;
    protected JFXPanel jfxPanel;
    protected Window window;

    public HswgTableDisplayContextPanel() throws Exception {
        this.setBorderSize(10, 40, 8, 8);
        this.setLine();
        this.setPreviousButton(BcWords.getInstance().initialize);
        this.setOkButton(BcWords.getInstance().apply);
        this.setCancelButton(BcWords.getInstance().cancel);
        String explanation = "\u5404\u7a2e\u9805\u76ee\u3092\u8a2d\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002\u300c" + BcWords.getInstance().apply + "\u300d\u30dc\u30bf\u30f3\u62bc\u4e0b\u306b\u3088\u308a\u3001\u30c6\u30fc\u30d6\u30eb\u306b\u9069\u7528\u3055\u308c\u307e\u3059\u3002";
        this.setDescription(explanation, -1);
        this.centerPanel.setLayout(new BorderLayout());
        this.centerPanel.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addTab("\u30ab\u30e9\u30e0\u8868\u793a", this.tableColumnConfigurePanel);
    }

    public void setTargetData(BcTableColumnModel tableColumnModel, String tagetName, ScfDisplayContext displayContextOrigin) throws Exception {
        this.tagetName = tagetName;
        this.displayContext1 = displayContextOrigin;
        List<ScfColumnContext> columnContextList = HswgTableDisplayUtil.createColumnContextList(tableColumnModel);
        ScfDisplayContext displayContext = new ScfDisplayContext();
        displayContext.columnContextMap = HswgTableDisplayUtil.toMap(columnContextList);
        this.setTargetDataL2(displayContext);
    }

    protected void setTargetDataL2(ScfDisplayContext displayContext) throws Exception {
        this.columnContextList = HswgTableDisplayUtil.toList(displayContext.columnContextMap);
        HswgColumnContextTableModel columnContextTableModel = new HswgColumnContextTableModel(this.columnContextList);
        this.tableColumnConfigurePanel.setDataModel(columnContextTableModel);
    }

    @Override
    protected void previousButtonAction() throws Exception {
        ScfDisplayContext displayContext = (ScfDisplayContext)this.displayContext1.clone();
        this.setTargetDataL2(displayContext);
    }

    @Override
    protected void okButtonAction() throws Exception {
        this.displayContext2 = new ScfDisplayContext();
        this.displayContext2.columnContextMap = HswgTableDisplayUtil.toMap(this.columnContextList);
        try {
            HswgTableDisplayUtil.save(this.tagetName, this.displayContext2, this.displayContext1);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        this.close();
    }

    @Override
    protected void cancelButtonAction() throws Exception {
        super.cancelButtonAction();
        this.close();
    }

    @Override
    public void close() {
        this.window.dispose();
    }

    public ScfDisplayContext showAsDialog(Component ownerCompow) throws Exception {
        this.displayContext2 = null;
        SwgDialog dialog = SwgUtil.createDialog(ownerCompow);
        dialog.getContentPane().add((Component)this, "Center");
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                try {
                    HswgTableDisplayContextPanel.this.cancelButtonAction();
                }
                catch (Exception ex) {
                    HswgTableDisplayContextPanel.this.handleException(ex);
                }
            }
        });
        dialog.setModal(true);
        dialog.setResizable(true);
        dialog.setTitle("\u8868\u793a\u8a2d\u5b9a\uff08" + this.tagetName + "\uff09");
        dialog.setIconImage(AwtImageHelper.getImageAsIcon("gear_64x64.png"));
        this.window = dialog;
        SwgUtil.setCenter(this.window, 560.0, 680.0);
        this.window.setVisible(true);
        return this.displayContext2;
    }
}

