/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.tbcp.fx;

import java.io.File;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.TextInputControl;
import javafx.stage.FileChooser;
import jp.co.extreme.base.table.BcTableUtil;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.control.FxTextArea;
import jp.co.extreme.fx.extension.FxxFilePathDndHelper;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xdts.fx.XdtsProfileSelectPane;
import jp.co.extreme.module.xdts.model.XdtsProfile;

class TbcpFilePane
extends FxBorderPane {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextArea filePathField = new FxTextArea();
    FxButton fileBrowsButton = FxUtil.createBrowsButton(null);
    FileChooser fileChooser = new FileChooser();

    public TbcpFilePane(String name) throws Exception {
        this.initComponent(name);
    }

    protected void initComponent(String name) throws Exception {
        this.filePathField.setPrefColumnCount(140);
        this.filePathField.setPrefRowCount(3);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(name), new Node[]{this.filePathField});
        this.fileBrowsButton.setOnAction(this.actionEventHandler);
        nodeUnit.addRightNodes(new Node[]{this.fileBrowsButton});
        this.centerPane.addNodeUnit(nodeUnit);
        this.setCenter((Node)this.centerPane);
        this.setPrefHeight(58.0);
        FxxFilePathDndHelper dndTargetHelper = new FxxFilePathDndHelper();
        dndTargetHelper.setTextInputControl((TextInputControl)this.filePathField, false);
        this.fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(BcTableUtil.Extention.csv.name().toUpperCase(), new String[]{"*." + (Object)((Object)BcTableUtil.Extention.csv)}), new FileChooser.ExtensionFilter(BcTableUtil.Extention.tsv.name().toUpperCase(), new String[]{"*." + (Object)((Object)BcTableUtil.Extention.tsv)}), new FileChooser.ExtensionFilter("All", new String[]{"*"})});
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.fileBrowsButton) {
            FxUtil.initFileChooser(this.fileChooser, this.filePathField.getText());
            File file = this.fileChooser.showOpenDialog(this.getScene().getWindow());
            if (file != null) {
                this.filePathField.setText(file.getPath());
            }
        } else if (ev.getSource() == this.fileBrowsButton) {
            XdtsProfileSelectPane profileSelectPane = new XdtsProfileSelectPane();
            XdtsProfile xdtsProfile = profileSelectPane.show(this.getScene().getWindow());
        }
    }
}

