/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.web.jquery.jstree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.css.common.CssUtil;
import jp.co.extreme.script.SrpClosureCompiler;
import jp.co.extreme.web.javascript.WbfNewJsUtil;
import jp.co.extreme.web.jquery.jstree.JsTreeItem;

public class JsTreeUtil {
    Map<String, String> scriptMap = new HashMap<String, String>();

    public static JsTreeUtil getInstance() {
        return SingletonHolder.instance;
    }

    public List<String> getHeadElementList() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("<link rel=\"stylesheet\" href=\"https://cdnjs.cloudflare.com/ajax/libs/jstree/3.3.17/themes/default/style.min.css\">");
        return list;
    }

    public List<String> getBodyScriptList() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("<script src=\"https://cdnjs.cloudflare.com/ajax/libs/jstree/3.3.17/jstree.min.js\"></script>");
        return list;
    }

    public String getScript(String selector, String ajaxUrl) throws Exception {
        String fileName = "jsTree_1.js";
        String script = this.scriptMap.get(fileName);
        if (script == null) {
            BcLogUtil.debug("is=" + this.getClass().getResourceAsStream(fileName));
            script = WbfNewJsUtil.getScript(JsTreeUtil.class.getResourceAsStream(fileName));
            this.scriptMap.put(fileName, script);
        }
        String scriptWk = script;
        scriptWk = scriptWk.replace("${selector}", selector);
        scriptWk = scriptWk.replace("${ajaxUrl}", ajaxUrl);
        String contextMenu = WbfNewJsUtil.getScript(JsTreeUtil.class.getResourceAsStream("jsTree_contextMenu.js"));
        scriptWk = scriptWk.replace("${contextMenu}", contextMenu);
        scriptWk = BcStringUtil.replace2(scriptWk, "${onClick}", this.onClickScript());
        scriptWk = SrpClosureCompiler.getInstance().compile(scriptWk);
        return WbfNewJsUtil.addTag(scriptWk);
    }

    public String toElementId(int num) throws Exception {
        return "jsTree_" + num;
    }

    public String elementIdDefault() throws Exception {
        return this.toElementId(1);
    }

    public void setTreeItemId(Collection<JsTreeItem> treeItemCollection, String parentId) throws Exception {
        int cnt = 0;
        for (JsTreeItem treeItem : treeItemCollection) {
            treeItem.id = String.valueOf(parentId) + "-" + ++cnt;
            if (BcStringUtil.isEmpty(treeItem.icon)) {
                treeItem.icon = BcCollectionUtil.isEmpty(treeItem.children) ? JsTreeIcon.jstree_file.value : JsTreeIcon.jstree_folder.value;
            }
            this.setTreeItemId(treeItem.children, treeItem.id);
        }
    }

    public void setTreeItemId(JsTreeItem treeItem) throws Exception {
        treeItem.id = "1";
        treeItem.text = "1";
        if (BcStringUtil.isEmpty(treeItem.icon)) {
            treeItem.icon = JsTreeIcon.jstree_folder.value;
        }
        this.setTreeItemId(treeItem.children, treeItem.id);
    }

    protected String onClickScript() throws Exception {
        return null;
    }

    public static JsTreeItem find(JsTreeItem treeItem, String id) throws Exception {
        if (id.equals(treeItem.id)) {
            return treeItem;
        }
        for (JsTreeItem treeItem2 : treeItem.children) {
            JsTreeItem treeItem3 = JsTreeUtil.find(treeItem2, id);
            if (treeItem3 == null) continue;
            return treeItem3;
        }
        return null;
    }

    public static enum JsTreeIcon {
        jstree_folder,
        jstree_file;

        public final String value = CssUtil.underScoreToHyphen(this.name());
    }

    private static final class SingletonHolder {
        private static final JsTreeUtil instance = new JsTreeUtil();

        private SingletonHolder() {
        }
    }
}

