/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.sql.context;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.core.BcUnicode;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdModel;
import jp.co.extreme.base.util.BcSIUnitUtil;
import jp.co.extreme.sql.SqlConstants;
import jp.co.extreme.sql.SqlDefinitionCondition;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlResultSet_Oracle;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.SqlType;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import oracle.sql.TIMESTAMP;
import org.apache.commons.codec.binary.Hex;

public class SqlContext_Oracle
extends SqlContext {
    public static final String DRIVER_CLASS_NAME = "oracle.jdbc.driver.OracleDriver";
    public static final String[] DRIVER_CLASS_NAMES = new String[]{"oracle.jdbc.driver.OracleDriver"};
    public static final int PORT_DEFAULT = 1521;
    public int MAX = Integer.MAX_VALUE;
    final long rawSizeMax = BcSIUnitUtil.binaryByteLong(2.0, BcSIUnitUtil.BinaryByteUnit.KiB);
    final long longRawSizeMax = BcSIUnitUtil.binaryByteLong(2.0, BcSIUnitUtil.BinaryByteUnit.GiB) - 1L;
    final long blobSizeMax = BcSIUnitUtil.binaryByteLong(44.0, BcSIUnitUtil.BinaryByteUnit.GiB) - 1L;
    private Map<Character, String> escapeCharacterMap;
    private List<String> reservedWordList;

    public SqlContext_Oracle(SqlConstants.DatabaseProduct databaseProduct) throws Exception {
        super(databaseProduct);
        this.setValidationQuery("SELECT 1 FROM dual");
    }

    @Override
    public boolean isSupported(SqlContext.Function function) {
        switch (function) {
            case connectionIsValid: {
                return false;
            }
            case statementIsClosed: {
                return false;
            }
            case queryTimeout: {
                return false;
            }
            case selectForUpdate: {
                return false;
            }
            case resultSetScroll: {
                return false;
            }
            case inputStreamAvailable: {
                return false;
            }
        }
        return true;
    }

    @Override
    public String[] getDriverClassNames() {
        return DRIVER_CLASS_NAMES;
    }

    @Override
    public int getDefaultPort() {
        return 1521;
    }

    @Override
    public Map<Character, String> getEscapeCharacterMap() {
        if (this.escapeCharacterMap == null) {
            this.escapeCharacterMap = new HashMap<Character, String>();
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.BS.char_), String.valueOf(String.valueOf(BcUnicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.BS.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.HT.char_), String.valueOf(String.valueOf(BcUnicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.HT.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.LF.char_), String.valueOf(String.valueOf(BcUnicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.LF.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.FF.char_), String.valueOf(String.valueOf(BcUnicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.FF.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.CR.char_), String.valueOf(String.valueOf(BcUnicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.CR.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.apostrophe.char_), String.valueOf(String.valueOf(BcUnicode.apostrophe.char_)) + String.valueOf(BcUnicode.apostrophe.char_));
        }
        return this.escapeCharacterMap;
    }

    @Override
    public String type_NUMBER(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case -6: {
                definition = this.create_NUMBER(DataSize.TINYINT.precision, 0);
                break;
            }
            case 5: {
                definition = this.create_NUMBER(DataSize.SMALLINT.precision, 0);
                break;
            }
            case 4: {
                definition = this.create_NUMBER(DataSize.INTEGER.precision, 0);
                break;
            }
            case -5: {
                definition = this.create_NUMBER(DataSize.BIGINT.precision, 0);
                break;
            }
            case 6: 
            case 7: {
                definition = "BINARY_FLOAT";
                break;
            }
            case 8: {
                definition = "BINARY_DOUBLE";
                break;
            }
            case 2: 
            case 3: {
                if (mmdField.dataSize > 38) break;
                definition = "NUMBER" + SqlUtil.toSizeStr(mmdField.dataSize, mmdField.decimalDigit);
            }
        }
        return definition;
    }

    public String create_NUMBER(int precision, int scale) throws Exception {
        return String.format("NUMBER(%d, %d)", precision, scale);
    }

    @Override
    public String type_CHAR(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case -15: 
            case 1: {
                if (mmdField.dataSize > 2000) break;
                definition = "NCHAR" + SqlUtil.toSizeStr(mmdField.dataSize);
                break;
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                if (mmdField.dataSize <= 4000) {
                    definition = "NVARCHAR2" + SqlUtil.toSizeStr(mmdField.dataSize);
                    break;
                }
                definition = "LONG";
                break;
            }
            case 2005: 
            case 2011: {
                definition = "CLOB";
            }
        }
        return definition;
    }

    @Override
    public String type_TIME(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case 91: 
            case 92: {
                definition = "DATE";
                break;
            }
            case 93: {
                definition = super.type_TIME(mmdField, definitionCondition);
            }
        }
        return definition;
    }

    @Override
    public String type_BIT_BOOLEAN(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case -7: 
            case 16: {
                definition = this.create_NUMBER(1, 0);
            }
        }
        return definition;
    }

    @Override
    public String type_BINARY(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        if ((long)mmdField.dataSize <= this.rawSizeMax) {
            definition = "RAW" + SqlUtil.toSizeStr(mmdField.dataSize);
        } else if ((long)mmdField.dataSize <= this.blobSizeMax) {
            definition = "BLOB";
        }
        return definition;
    }

    @Override
    public Object toJdbcValue(Object srcValue, int sqlTypeId) throws Exception {
        if (srcValue == null) {
            return null;
        }
        Class<?> srcClass = srcValue.getClass();
        Object dstValue = srcValue;
        if (BigDecimal.class.isAssignableFrom(srcClass)) {
            BigDecimal bigDecimal = (BigDecimal)srcValue;
            if (bigDecimal.scale() == 0) {
                if (bigDecimal.precision() <= 4) {
                    dstValue = bigDecimal.shortValue();
                }
                if (bigDecimal.precision() <= 9) {
                    dstValue = bigDecimal.intValue();
                }
                if (bigDecimal.precision() <= 18) {
                    dstValue = bigDecimal.longValue();
                }
            }
        } else if (TIMESTAMP.class.isAssignableFrom(srcClass)) {
            TIMESTAMP oracleTimestamp = (TIMESTAMP)srcValue;
            Timestamp timestamp = oracleTimestamp.timestampValue();
            Calendar calendar = BcTimeUtil.toCalendar(timestamp.getTime());
            dstValue = calendar;
        } else {
            dstValue = super.toJdbcValue(srcValue, sqlTypeId);
        }
        return dstValue;
    }

    @Override
    public MmdModel convertModelMetaData(MmdModel srcMmdModel, SqlContext dstSqlContext) throws Exception {
        MmdModel dstMmdModel = (MmdModel)srcMmdModel.clone();
        if (this.getDatabaseProduct() == dstSqlContext.getDatabaseProduct()) {
            return dstMmdModel;
        }
        int i = 0;
        while (i < dstMmdModel.getFieldCount()) {
            MmdField mmdField = dstMmdModel.getField(i);
            SqlType sqlType = SqlType.getById(mmdField.sqlTypeId);
            switch (sqlType) {
                case ORACLE_FLOAT: {
                    mmdField.sqlTypeId = 6;
                    mmdField.dataSize = 32;
                    break;
                }
                case ORACLE_DOUBLE: {
                    mmdField.sqlTypeId = 8;
                    mmdField.dataSize = 64;
                    break;
                }
                case NUMERIC: 
                case DECIMAL: {
                    if (mmdField.decimalDigit != 0) break;
                    if (mmdField.dataSize <= 4) {
                        mmdField.sqlTypeId = 5;
                        mmdField.dataSize = 16;
                        break;
                    }
                    if (mmdField.dataSize <= 9) {
                        mmdField.sqlTypeId = 4;
                        mmdField.dataSize = 32;
                        break;
                    }
                    if (mmdField.dataSize > 18) break;
                    mmdField.sqlTypeId = -5;
                    mmdField.dataSize = 64;
                    break;
                }
            }
            ++i;
        }
        return dstMmdModel;
    }

    @Override
    public Object toCommonTypeValue(Object jdbcValue) throws Exception {
        if (jdbcValue == null) {
            return null;
        }
        Class<?> fromClass = jdbcValue.getClass();
        Object fieldValue = null;
        if (TIMESTAMP.class.isAssignableFrom(fromClass)) {
            TIMESTAMP oracleTimestamp = (TIMESTAMP)jdbcValue;
            Timestamp timestamp = oracleTimestamp.timestampValue();
            Calendar calendar = BcTimeUtil.toCalendar(timestamp.getTime());
            fieldValue = calendar;
        } else {
            fieldValue = super.toCommonTypeValue(jdbcValue);
        }
        return fieldValue;
    }

    @Override
    public String setLimit(String srcQuery, long limit, long offset) throws Exception {
        StringBuilder sb1 = new StringBuilder();
        if (offset > 0L) {
            sb1.append(" OFFSET " + offset);
        }
        if (limit > 0L) {
            sb1.append(" FETCH NEXT " + limit + " ROWS ONLY");
        }
        return String.valueOf(srcQuery) + sb1;
    }

    @Override
    public SqlResultSet convToSqlResultSet(ResultSet rs, SqlStatement sqlStatement) throws SQLException {
        return new SqlResultSet_Oracle(rs, sqlStatement);
    }

    @Override
    public String createBinaryInsert(byte[] bytes) throws Exception {
        String hex = new String(Hex.encodeHex((byte[])bytes));
        return "HEXTORAW(" + BcStringUtil.singleQuotation(hex) + ")";
    }

    public static String cretaeUrl(String hostName, int port, String databaseName) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("jdbc:oracle:thin:@//");
        sb.append(hostName);
        if (port <= 0) {
            port = 1521;
        }
        sb.append(":" + port);
        sb.append("/");
        sb.append(databaseName);
        return sb.toString();
    }

    @Override
    public boolean isReservedWord(String word) throws Exception {
        if (this.reservedWordList == null) {
            this.reservedWordList = this.cretaeReservedWordList("oracle");
        }
        return this.reservedWordList.contains(word.toLowerCase());
    }

    public static enum DataSize {
        TINYINT(3),
        SMALLINT(5),
        INTEGER(10),
        BIGINT(19),
        REAL(23),
        DOUBLE(49);

        public final int precision;

        private DataSize(int precision) {
            this.precision = precision;
        }
    }
}

