/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.util.BcReflectUtil;

public class BcSharedObjectManager<K, V>
extends BcLoggableObject
implements AutoCloseable {
    private Map<K, V> map = new ConcurrentHashMap();

    public static BcSharedObjectManager getInstance() {
        return SingletonHolder.instance;
    }

    public BcSharedObjectManager() {
        this.clear();
    }

    public void clear() {
        this.map.clear();
    }

    public V put(K key, V value) {
        return this.map.put(key, value);
    }

    public V get(K key) {
        return this.map.get(key);
    }

    public V get(K key, Class clazz, boolean create) throws Exception {
        Object value = this.get(key);
        if (value == null && create) {
            value = BcReflectUtil.createInstance(clazz);
            this.put(key, value);
        }
        return value;
    }

    public V get(K key, String className, boolean create) throws Exception {
        Class<?> clazz = Class.forName(className);
        return this.get(key, clazz, create);
    }

    public V get(K key, boolean create) throws Exception {
        return this.get(key, key.toString(), create);
    }

    public V remove(K key) {
        return this.map.remove(key);
    }

    public Map<K, V> getMap() {
        return this.map;
    }

    @Override
    public void close() throws Exception {
        this.clear();
        this.map = null;
    }

    private static final class SingletonHolder {
        private static final BcSharedObjectManager instance = new BcSharedObjectManager();

        private SingletonHolder() {
        }
    }
}

