/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import javafx.collections.ObservableList;
import javafx.scene.Node;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.table.FxTableRowList;
import jp.co.extreme.fx.table.FxTableUtil;
import jp.co.extreme.fx.table.FxTableView;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xdts.common.XdtsUtil;
import jp.co.extreme.module.xdts.fx.XdtsTaskMenuPane;
import jp.co.extreme.module.xdts.fx.XdtsTimerTableModel;
import jp.co.extreme.module.xdts.model.XdtsTimer;
import jp.co.extreme.module.xdts.stub.XdtsTimerStub;

class XdtsTimerTablePane
extends FxBorderPane {
    XdtsTimerTableModel timerTableModel = new XdtsTimerTableModel();
    InnerTableView tableView;
    Object selectedValue;
    XdtsTaskMenuPane taskMenuPane;

    public XdtsTimerTablePane(XdtsTaskMenuPane taskMenuPane) throws Exception {
        this.taskMenuPane = taskMenuPane;
        this.initComponent();
        this.doLoad();
    }

    protected void initComponent() throws Exception {
        FxUtil.defaultInitialize((Node)this);
    }

    protected void doLoad() throws Exception {
        this.timerTableModel.timerList = XdtsTimerStub.getInstance().getTimerList();
        FxTableRowList tableRowList = new FxTableRowList(this.timerTableModel);
        this.tableView = new InnerTableView();
        BcTableColumnModel tableColumnModel = XdtsUtil.createTimerTableColumnModel();
        FxTableUtil.createColumn(tableColumnModel, this.tableView, null);
        this.tableView.setItems(tableRowList);
        this.setCenter((Node)this.tableView);
    }

    class InnerTableView<S>
    extends FxTableView<S> {
        @Override
        public void rowSelectionChanged(FxTableView tableView, ObservableList<Integer> rowIdList, int prevRowId, int nextRowId) throws Exception {
            super.rowSelectionChanged((FxTableView)this, rowIdList, prevRowId, nextRowId);
            XdtsTimer timer = XdtsTimerTablePane.this.timerTableModel.timerList.get(nextRowId);
            try {
                XdtsTimerTablePane.this.taskMenuPane.setTimer(timer);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }
}

