/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.common;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import jp.co.extreme.base.core.BcBooleanUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.mmd.MmdIndex;
import jp.co.extreme.base.mmd.MmdIndexElement;
import jp.co.extreme.base.mmd.MmdModel;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcCsvUtil;
import jp.co.extreme.etc.model.EtcColumnCondition;
import jp.co.extreme.module.xdts.model.v001.XdtsOrderBy;
import jp.co.extreme.module.xdts.model.v001.XdtsOrderByElement;
import jp.co.extreme.module.xdts.model.v001.XdtsWhere;
import jp.co.extreme.module.xdts.model.v001.XdtsWhereElement;
import jp.co.extreme.sql.SqlConditionParser;
import jp.co.extreme.sql.SqlConditionSpliter;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;
import jp.co.extreme.sql.model.SqlWhereQuery;

public class XdtsSqlConditionUtil {
    private XdtsSqlConditionUtil() throws Exception {
    }

    public static List<String> createOrderByList(MmdIndex mmdIndex) throws Exception {
        ArrayList<String> orderByList = new ArrayList<String>();
        int i = 0;
        while (i < mmdIndex.indexElementList.size()) {
            MmdIndexElement indexElement = mmdIndex.indexElementList.get(i);
            StringBuilder sb = new StringBuilder();
            sb.append(indexElement.columnName);
            if (!indexElement.isAscending) {
                sb.append(" DESC");
            }
            orderByList.add(sb.toString());
            ++i;
        }
        return orderByList;
    }

    public static String toOrderByString(XdtsOrderBy xdtsOrderBy) throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < xdtsOrderBy.orderByElementList.size()) {
            XdtsOrderByElement orderByElement = xdtsOrderBy.orderByElementList.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(orderByElement.name);
            if (!orderByElement.isAscending) {
                sb.append(" DESC");
            }
            ++i;
        }
        return sb.toString();
    }

    public static SqlSelectQuery createSelectQuery(SqlContext sqlContext, MmdModel mmdModel) throws Exception {
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        List<String> tableColumnNameList = MmdUtil.toTableColumnNameList(mmdModel);
        selectQuery.getSelectColumnList().addAll(tableColumnNameList);
        selectQuery.setFromClause(mmdModel.tableName);
        return selectQuery;
    }

    public static void createWhereClause_L2(SqlContext sqlContext, XdtsWhere xdtsWhere, EtcColumnCondition columnCondition) throws Exception {
        if (BcStringUtil.isEmpty(columnCondition.value)) {
            return;
        }
        if (SqlUtil.isNumber(columnCondition.sqlTypeId)) {
            SqlWhereQuery sqlWhereQuery = new SqlWhereQuery();
            SqlConditionParser.getInstance().parseCondition4Number(sqlWhereQuery, sqlContext, columnCondition.tableColumnName, columnCondition.value);
            XdtsWhere xdtsWhere2 = XdtsSqlConditionUtil.toXdtsWhere(sqlWhereQuery);
            if (!BcCollectionUtil.isEmpty(xdtsWhere2.whereElementList)) {
                for (XdtsWhereElement xdtsWhereElement : xdtsWhere2.whereElementList) {
                    xdtsWhere.whereElementList.add(xdtsWhereElement);
                }
            }
        } else if (SqlUtil.isText(columnCondition.sqlTypeId)) {
            List<String> conditionValueList = SqlConditionSpliter.getInstance().split(columnCondition.value);
            if (conditionValueList.size() > 0) {
                String tmpStr = sqlContext.createPatternMatchClause(columnCondition.tableColumnName, columnCondition.patternMatch, true, false, conditionValueList);
                XdtsWhereElement whereElement = new XdtsWhereElement();
                if (columnCondition.isAnd) {
                    whereElement.setLogical_AND();
                } else {
                    whereElement.setLogical_OR();
                }
                whereElement.setFormula(tmpStr);
                xdtsWhere.whereElementList.add(whereElement);
            }
        } else if (SqlUtil.isBoolean(columnCondition.sqlTypeId)) {
            Boolean bool = BcBooleanUtil.parseBoolean(columnCondition.value, true);
            if (bool != null) {
                XdtsWhereElement whereElement = new XdtsWhereElement();
                whereElement.setLogical_AND();
                if (columnCondition.sqlTypeId == -7) {
                    whereElement.setFormula(sqlContext.toCondition_boolean(columnCondition.tableColumnName, bool, true));
                } else {
                    whereElement.setFormula(sqlContext.toCondition_boolean(columnCondition.tableColumnName, bool, true));
                }
                xdtsWhere.whereElementList.add(whereElement);
            }
        } else if (columnCondition.sqlTypeId == 91 || columnCondition.sqlTypeId == 93) {
            List<String> valueList = BcCsvUtil.parseCsvRow(columnCondition.value, true);
            Calendar calendar1 = BcTimeUtil.toCalendar(valueList.get(0));
            Calendar calendar2 = BcTimeUtil.toCalendar(valueList.get(1));
            XdtsWhereElement whereElement = new XdtsWhereElement();
            whereElement.setLogical_AND();
            if (columnCondition.sqlTypeId == 91) {
                whereElement.setFormula(sqlContext.toCondition_period_date(columnCondition.tableColumnName, calendar1, calendar2));
            } else {
                whereElement.setFormula(sqlContext.toCondition_period_datetime(columnCondition.tableColumnName, calendar1, calendar2));
            }
            xdtsWhere.whereElementList.add(whereElement);
        } else {
            BcLogUtil.debug("Not suppoted JDBC Type. " + columnCondition.sqlTypeId + ":" + SqlUtil.toJdbcType(columnCondition.sqlTypeId) + " tableColumnName=" + columnCondition.tableColumnName);
        }
    }

    public static XdtsWhere toXdtsWhere(SqlWhereQuery sqlWhereQuery) throws Exception {
        XdtsWhere xdtsWhere = new XdtsWhere();
        for (SqlWhereElement sqlWhereElement : sqlWhereQuery.getWhereElementList()) {
            XdtsWhereElement xdtsWhereElement = XdtsSqlConditionUtil.toXdtsWhereElement(sqlWhereElement);
            xdtsWhere.whereElementList.add(xdtsWhereElement);
        }
        return xdtsWhere;
    }

    public static XdtsWhereElement toXdtsWhereElement(SqlWhereElement sqlWhereElement1) throws Exception {
        XdtsWhereElement xdtsWhereElement1 = new XdtsWhereElement();
        xdtsWhereElement1.setLogical(sqlWhereElement1.getLogical());
        xdtsWhereElement1.setFormula(sqlWhereElement1.getFormula());
        if (!BcCollectionUtil.isEmpty(sqlWhereElement1.whereElementList)) {
            for (SqlWhereElement sqlWhereElement2 : sqlWhereElement1.whereElementList) {
                XdtsWhereElement xdtsWhereElement2 = XdtsSqlConditionUtil.toXdtsWhereElement(sqlWhereElement2);
                xdtsWhereElement1.whereElementList.add(xdtsWhereElement2);
            }
        }
        return xdtsWhereElement1;
    }
}

