/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.server;

import java.util.HashMap;
import java.util.Map;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.httpserver.HtsvSiteContext;
import jp.co.extreme.module.wbs1.dao.Wbs1WorkspaceDAO;
import jp.co.extreme.module.wbs1.model.Wbs1Workspace;
import jp.co.extreme.module.xweb.common.XwebUtil;

public class WorkspaceManager
extends BcLoggableObject {
    private Map<Long, Wbs1Workspace> workspaceMap = new HashMap<Long, Wbs1Workspace>();

    public static WorkspaceManager getInstance() {
        return SingletonHolder.instance;
    }

    public Wbs1Workspace getWorkspace(HtsvSiteContext siteContext, long workspaceId) throws Exception {
        Wbs1Workspace workspace = this.workspaceMap.get(workspaceId);
        if (workspace == null) {
            Throwable throwable = null;
            Object var6_7 = null;
            try (DtsSession dtsSession = XwebUtil.createDataSourceSession(siteContext, this);){
                workspace = (Wbs1Workspace)Wbs1WorkspaceDAO.getInstance().getById(dtsSession, workspaceId);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (workspace != null) {
                this.workspaceMap.put(workspace.id, workspace);
            }
        }
        return workspace;
    }

    private static final class SingletonHolder {
        private static final WorkspaceManager instance = new WorkspaceManager();

        private SingletonHolder() {
        }
    }
}

