/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.activation;

import java.io.File;
import org.apache.tika.Tika;

public final class BcMimeUtil {
    static Tika tika = new Tika();

    private BcMimeUtil() {
    }

    public static String getMimeType(String fileName) throws Exception {
        String mimeType = tika.detect(fileName);
        return mimeType;
    }

    public static String getMimeType(File file) throws Exception {
        return BcMimeUtil.getMimeType(file.getName());
    }

    public static boolean isImageMime(String mimeType) throws Exception {
        return mimeType.toLowerCase().startsWith("image");
    }

    public static boolean isImageFile(String fileName) throws Exception {
        String mimeType = BcMimeUtil.getMimeType(fileName);
        if (mimeType == null) {
            return false;
        }
        return BcMimeUtil.isImageMime(mimeType);
    }

    public static enum MimeType {
        application_javascript("text/javascript"),
        application_json("application/json"),
        application_octet_stream("application/octet-stream"),
        application_xml("application/xml; charset=utf-8"),
        text_plain("text/plain"),
        text_csv("text/csv"),
        text_tab_separated_values("text/tab-separated-values");

        public final String value;

        private MimeType(String value) {
            this.value = value;
        }
    }
}

