/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.server;

import java.net.Socket;
import java.util.Calendar;
import java.util.List;
import jp.co.extreme.base.core.BcJavaConstants;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.net.BcAddressPort;
import jp.co.extreme.base.net.BcNetUtil;
import jp.co.extreme.base.runtime.BcRuntimeContext;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.DtsSessionFactory;
import jp.co.extreme.datasource.DtsSessionFactoryManegaer;
import jp.co.extreme.rmi.agent.RmiAgent;
import jp.co.extreme.rmi.connector.RmiObjectStreamConnector;
import jp.co.extreme.rmi.model.RmiRmoArgument;
import jp.co.extreme.rmi.server.RmiAcceptThread;
import jp.co.extreme.rmi.server.RmiAgentEventHandler;
import jp.co.extreme.rmi.server.RmiRemoteAgent;
import jp.co.extreme.rmi.server.RmiServer;
import jp.co.extreme.scf.server.ScfAbstractServerModule;
import jp.co.extreme.scf.server.ScfServerContainer;
import jp.co.extreme.scf4.dao.ScfConnectionDAO;
import jp.co.extreme.scf4.model.ScfConnection;
import jp.co.extreme.scf4.server.ScfRmiRedirctor;

public class Scf4ServerModule
extends ScfAbstractServerModule {
    RmiAgentEventHandlerImpl rmiAgentEventHandler = new RmiAgentEventHandlerImpl();

    @Override
    public void init() throws Exception {
        if (ScfServerContainer.getInstance().rmiServerModule != null) {
            RmiServer rmiServer = ScfServerContainer.getInstance().rmiServerModule.getServer();
            rmiServer.addAgentEventHandler(this.rmiAgentEventHandler);
            ScfRmiRedirctor rmiRedirctor = new ScfRmiRedirctor();
            rmiServer.setRedirector(rmiRedirctor);
        }
    }

    @Override
    public void start() throws Exception {
        this.resolveRmiOnline();
    }

    @Override
    public void end() throws Exception {
        if (ScfServerContainer.getInstance().rmiServerModule != null) {
            ScfServerContainer.getInstance().rmiServerModule.getServer().removeAgentEventHandler(this.rmiAgentEventHandler);
        }
    }

    protected void resolveRmiOnline() throws Exception {
        if (ScfServerContainer.getInstance().rmiServerModule == null) {
            return;
        }
        RmiServer rmiServer = ScfServerContainer.getInstance().rmiServerModule.getServer();
        RmiAcceptThread acceptThread = rmiServer.acceptThread;
        if (acceptThread == null || acceptThread.serverSocket == null) {
            return;
        }
        String locaHostAddress = acceptThread.serverSocket.getInetAddress().getHostAddress();
        int localPort = acceptThread.serverSocket.getLocalPort();
        Throwable throwable = null;
        Object var6_8 = null;
        try (DtsSession dtsSession = DtsSessionFactoryManegaer.getInstance().getSessionFactoryMain().createSession(this);){
            this.getLogger().info("RMI\u63a5\u7d9a\u4e2d\u30ea\u30b9\u30c8\u3092\u62bd\u51fa\u4e2d... locaHostAddress=" + locaHostAddress + " localPort=" + localPort);
            List scfConnectionList = ScfConnectionDAO.getInstance().getListByOnline(dtsSession, locaHostAddress, localPort);
            this.getLogger().info("RMI\u63a5\u7d9a\u4e2d\u4ef6\u6570=" + scfConnectionList.size());
            if (!BcCollectionUtil.isEmpty(scfConnectionList)) {
                Calendar now = BcTimeUtil.createCalendar();
                String nowStr = BcTimeUtil.toString(now, "yyyy/MM/dd HH:mm:ss");
                for (ScfConnection scfConnection : scfConnectionList) {
                    scfConnection.disconnectDatetime = scfConnection.acceptDatetime;
                    scfConnection.note = "\u5207\u65ad\u65e5\u6642\u4e0d\u660e:\u5207\u65ad\u65e5\u6642\u8a2d\u5b9a\u65e5\u6642=" + nowStr;
                }
                ScfConnectionDAO.getInstance().putEntityCollection(dtsSession, scfConnectionList);
                dtsSession.commit();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void copyToClientConnection(BcRuntimeContext runtimeContext, ScfConnection scfConnection) {
        scfConnection.javaVersion = runtimeContext.getSystemProperties().getProperty(BcJavaConstants.SysKey.java_version.value);
        scfConnection.osName = runtimeContext.getSystemProperties().getProperty(BcJavaConstants.SysKey.os_name.value);
        scfConnection.osVersion = runtimeContext.getSystemProperties().getProperty(BcJavaConstants.SysKey.os_version.value);
        scfConnection.osArch = runtimeContext.getSystemProperties().getProperty(BcJavaConstants.SysKey.os_arch.value);
        scfConnection.userName = runtimeContext.getSystemProperties().getProperty(BcJavaConstants.SysKey.user_name.value);
        scfConnection.userDir = runtimeContext.getSystemProperties().getProperty(BcJavaConstants.SysKey.user_dir.value);
    }

    class RmiAgentEventHandlerImpl
    implements RmiAgentEventHandler {
        RmiAgentEventHandlerImpl() {
        }

        @Override
        public void agentAdded(RmiAgent rmixAgent) throws Exception {
        }

        @Override
        public void agentRemoved(RmiAgent rmixAgent) throws Exception {
            DtsSessionFactory sessionFactory = DtsSessionFactoryManegaer.getInstance().getSessionFactoryMain();
            DtsSession dtsSession = sessionFactory.createSession(this);
            try {
                ScfConnection rmixConnection = ScfConnectionDAO.getInstance().getByAgentHashCode(dtsSession, rmixAgent.hashCode());
                rmixConnection.disconnectDatetime = BcTimeUtil.createCalendar();
                ScfConnectionDAO.getInstance().putEntity(dtsSession, rmixConnection);
                dtsSession.commit();
            }
            finally {
                dtsSession.desturuct();
            }
        }

        @Override
        public void firstStatusChecked(RmiAgent rmixAgent) throws Exception {
            RmiRemoteAgent rmiRemoteAgent = (RmiRemoteAgent)rmixAgent;
            ScfConnection rmixConnection = new ScfConnection();
            rmixConnection.acceptDatetime = BcTimeUtil.toCalendar(rmiRemoteAgent.getContext().acceptDatetime);
            rmixConnection.agentHashCode = rmixAgent.hashCode();
            RmiObjectStreamConnector rmixConnector = (RmiObjectStreamConnector)rmiRemoteAgent.getConnector();
            Socket socket = rmixConnector.getSocket();
            rmixConnection.localHostAddress = socket.getLocalAddress().getHostAddress();
            rmixConnection.localHostName = socket.getLocalAddress().getHostName();
            rmixConnection.localPort = socket.getLocalPort();
            BcAddressPort remoteAddressPort = BcNetUtil.parseAddressPort(socket.getRemoteSocketAddress().toString());
            rmixConnection.remoteHostAddress = remoteAddressPort.address;
            rmixConnection.remotePort = remoteAddressPort.port;
            BcRuntimeContext runtimeContext = rmiRemoteAgent.getContext().getRuntimeContext();
            Scf4ServerModule.this.copyToClientConnection(runtimeContext, rmixConnection);
            DtsSessionFactory sessionFactory = DtsSessionFactoryManegaer.getInstance().getSessionFactoryMain();
            DtsSession dtsSession = sessionFactory.createSession(this);
            try {
                ScfConnectionDAO.getInstance().putEntity(dtsSession, rmixConnection);
                dtsSession.commit();
            }
            finally {
                dtsSession.desturuct();
            }
        }

        @Override
        public void invokeException(RmiRmoArgument rmixArg, Throwable throwable) throws Exception {
        }
    }
}

