/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf.common;

import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.util.BcRandamUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.scf.common.ScfHandle;
import jp.co.extreme.scf.common.ScfHandleManager;

public class ScfHandleManagerImpl
extends BcLoggableObject
implements ScfHandleManager {
    private long validationInterval = 60000L;
    private long validationDelay = 5000L;
    private int handleIdLength = 48;
    private Map<Object, ScfHandle> handleMap = new ConcurrentHashMap<Object, ScfHandle>();
    private Random random = new Random();
    private boolean isCluster;
    private int removedHandleCount;

    public long getValidationInterval() {
        return this.validationInterval;
    }

    public void setValidationInterval(long validationInterval) {
        this.validationInterval = validationInterval;
    }

    public ScfHandleManagerImpl(boolean isCluster) {
        this.isCluster = isCluster;
    }

    @Override
    public void start() throws Exception {
        this.getLogger().info("Handle Manager starting...:validationInterval=" + BcTimeUtil.toDurationString2(this.validationInterval));
        ValidationTask validationTask = new ValidationTask();
        Timer timer = new Timer();
        timer.schedule((TimerTask)validationTask, this.validationDelay, this.validationInterval);
    }

    @Override
    public String craeteHandleId() throws Exception {
        String handleId = null;
        while (this.handleMap.containsKey(handleId = BcRandamUtil.createCode(this.random, 5, this.handleIdLength))) {
        }
        return handleId;
    }

    @Override
    public void addHandle(ScfHandle handle) throws Exception {
        if (!this.isCluster) {
            if (BcStringUtil.isEmpty(handle.getHandleId())) {
                String handleId;
                while (this.getHandle(handleId = this.craeteHandleId(), false) != null) {
                }
                handle.setHandleId(handleId);
            }
        } else {
            ScfHandle handle2 = this.handleMap.get(handle.getHandleId());
            if (handle2 != null) {
                throw new Exception("invalid handleId '" + handle.getHandleId() + "'");
            }
        }
        handle.setStartTime(System.currentTimeMillis());
        handle.setLastAccessTime(handle.getStartTime());
        this.handleMap.put(handle.getHandleId(), handle);
        handle.setHandleManager(this);
    }

    @Override
    public ScfHandle getHandle(Object handleId, boolean checkExistence) throws Exception {
        if (BcStringUtil.isEmpty(handleId)) {
            throw new IllegalArgumentException(BcWords.getInstance().The_handle_ID_is_invalid_ID_$(handleId));
        }
        ScfHandle handle = this.handleMap.get(handleId);
        if (handle == null) {
            if (checkExistence) {
                throw new Exception(BcWords.getInstance().$_does_not_exists("handleId=" + handleId));
            }
        } else {
            handle.setLastAccessTime(System.currentTimeMillis());
            handle.incrementAccessCount();
        }
        return handle;
    }

    @Override
    public ScfHandle getHandle(Object handleId) throws Exception {
        return this.getHandle(handleId, true);
    }

    @Override
    public ScfHandle removeHandle(Object handleId) throws Exception {
        ScfHandle handle = this.handleMap.remove(handleId);
        if (handle != null) {
            ++this.removedHandleCount;
            try {
                handle.close();
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
        }
        return handle;
    }

    @Override
    public Map<Object, ScfHandle> getHandleMap() {
        return this.handleMap;
    }

    public void removeHandleByOwner(Object owner) throws Exception {
        Object[] handles = null;
        handles = this.handleMap.values().toArray();
        int i = 0;
        while (i < handles.length) {
            ScfHandle handle = (ScfHandle)handles[i];
            if (handle.getOwner() != null && handle.getOwner().equals(owner)) {
                this.removeHandle(handle.getHandleId());
            }
            ++i;
        }
    }

    @Override
    public void validation() throws Exception {
        this.getLogger().debug("---- Handle Manager Validation");
        Object[] handles = this.handleMap.values().toArray();
        this.getLogger().debug("handles.length=" + handles.length);
        int i = 0;
        while (i < handles.length) {
            long lifeSpan;
            ScfHandle handle = (ScfHandle)handles[i];
            if (handle.getTimeout() > 0L && (lifeSpan = System.currentTimeMillis() - handle.getLastAccessTime()) >= handle.getTimeout()) {
                this.removeHandle(handle.getHandleId());
                this.getLogger().debug("validation-removeHandle:handleId=" + handle.getHandleId() + " lifeSpan=" + BcTimeUtil.toDurationString2(lifeSpan));
            }
            ++i;
        }
    }

    public int getRemovedHandleCount() {
        return this.removedHandleCount;
    }

    class ValidationTask
    extends TimerTask {
        ValidationTask() {
        }

        @Override
        public void run() {
            try {
                ScfHandleManagerImpl.this.validation();
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
    }
}

