/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.datasource;

import java.util.Locale;
import jp.co.extreme.datasource.DtsAbstractSession;
import jp.co.extreme.datasource.DtsConnectionManager;
import jp.co.extreme.datasource.DtsSessionFactory;
import jp.co.extreme.sql.SqlConnection;
import jp.co.extreme.sql.context.SqlContext;

public class DtsSession
extends DtsAbstractSession {
    private DtsSessionFactory sessionFactory;
    private Locale locale;
    private DtsConnectionManager connectionManager;
    private SqlContext sqlContext;
    private SqlConnection sqlConn;

    public DtsSession(DtsSessionFactory sessionFactory) {
        this.startTime = System.currentTimeMillis();
        this.sessionFactory = sessionFactory;
        this.setLogger(sessionFactory.getLogger());
    }

    public DtsSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return Locale.getDefault();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public DtsConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void setConnectionManager(DtsConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public SqlContext getSqlContext() {
        return this.sqlContext;
    }

    public void setSqlContext(SqlContext sqlContext) {
        this.sqlContext = sqlContext;
    }

    public SqlConnection getConnection() throws Exception {
        if (this.sqlConn == null) {
            this.sqlConn = this.connectionManager.getConnection(this.getOwner());
        }
        return this.sqlConn;
    }

    public void setConnection(SqlConnection sqlConn) {
        this.sqlConn = sqlConn;
    }

    public boolean hasConnection() {
        return this.sqlConn != null;
    }

    public void commit() throws Exception {
        if (this.sqlConn != null && !this.sqlConn.getAutoCommit()) {
            this.sqlConn.commit();
        }
    }

    public void rollback() throws Exception {
        if (this.sqlConn != null) {
            this.sqlConn.rollback();
        } else {
            this.getLogger().warning("sqlCon=" + this.sqlConn);
        }
    }

    public void desturuct() throws Exception {
        if (this.sqlConn != null) {
            if (!this.sqlConn.isClosed()) {
                try {
                    this.sqlConn.close();
                }
                catch (Exception ex) {
                    this.getLogger().error(ex);
                }
            }
            this.sqlConn = null;
        }
        this.locale = null;
        this.connectionManager = null;
        this.sqlContext = null;
        if (this.sessionFactory != null) {
            this.sessionFactory.getSessionList().remove(this);
        }
        this.sessionFactory = null;
    }

    @Override
    public void close() {
        try {
            this.desturuct();
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
        }
    }
}

