/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.peer.ChoicePeer;
import sun.awt.SunToolkit;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WToolkit;
import sun.awt.windows.WWindowPeer;

final class WChoicePeer
extends WComponentPeer
implements ChoicePeer {
    private WindowListener windowListener;

    @Override
    public Dimension getMinimumSize() {
        FontMetrics fontMetrics = this.getFontMetrics(((Choice)this.target).getFont());
        Choice choice = (Choice)this.target;
        int n = 0;
        int n2 = choice.getItemCount();
        while (n2-- > 0) {
            n = Math.max(fontMetrics.stringWidth(choice.getItem(n2)), n);
        }
        return new Dimension(28 + n, Math.max(fontMetrics.getHeight() + 6, 15));
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public native void select(int var1);

    @Override
    public void add(String string, int n) {
        this.addItem(string, n);
    }

    @Override
    public boolean shouldClearRectBeforePaint() {
        return false;
    }

    @Override
    public native void removeAll();

    @Override
    public native void remove(int var1);

    public void addItem(String string, int n) {
        this.addItems(new String[]{string}, n);
    }

    public native void addItems(String[] var1, int var2);

    @Override
    public synchronized native void reshape(int var1, int var2, int var3, int var4);

    WChoicePeer(Choice choice) {
        super(choice);
    }

    @Override
    native void create(WComponentPeer var1);

    @Override
    void initialize() {
        WWindowPeer wWindowPeer;
        Object object;
        Choice choice = (Choice)this.target;
        int n = choice.getItemCount();
        if (n > 0) {
            object = new String[n];
            for (int i = 0; i < n; ++i) {
                object[i] = choice.getItem(i);
            }
            this.addItems((String[])object, 0);
            if (choice.getSelectedIndex() >= 0) {
                this.select(choice.getSelectedIndex());
            }
        }
        if ((object = SunToolkit.getContainingWindow((Component)this.target)) != null && (wWindowPeer = (WWindowPeer)((Component)object).getPeer()) != null) {
            this.windowListener = new WindowAdapter(){

                @Override
                public void windowIconified(WindowEvent windowEvent) {
                    WChoicePeer.this.closeList();
                }

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    WChoicePeer.this.closeList();
                }
            };
            wWindowPeer.addWindowListener(this.windowListener);
        }
        super.initialize();
    }

    @Override
    protected void disposeImpl() {
        WWindowPeer wWindowPeer;
        Window window = SunToolkit.getContainingWindow((Component)this.target);
        if (window != null && (wWindowPeer = (WWindowPeer)window.getPeer()) != null) {
            wWindowPeer.removeWindowListener(this.windowListener);
        }
        super.disposeImpl();
    }

    void handleAction(final int n) {
        final Choice choice = (Choice)this.target;
        WToolkit.executeOnEventHandlerThread(choice, new Runnable(){

            @Override
            public void run() {
                choice.select(n);
                WChoicePeer.this.postEvent(new ItemEvent(choice, 701, choice.getItem(n), 1));
            }
        });
    }

    int getDropDownHeight() {
        Choice choice = (Choice)this.target;
        FontMetrics fontMetrics = this.getFontMetrics(choice.getFont());
        int n = Math.min(choice.getItemCount(), 8);
        return fontMetrics.getHeight() * n;
    }

    native void closeList();
}

