/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.bouncycastle.operator.DigestCalculatorProvider;

public class SMIMESignedParser
extends CMSSignedDataParser {
    Object message;
    MimeBodyPart content;

    private static File getTmpFile() throws MessagingException {
        try {
            return File.createTempFile("bcMail", ".mime");
        }
        catch (IOException iOException) {
            throw new MessagingException("can't extract input stream: " + iOException);
        }
    }

    private static CMSTypedStream getSignedInputStream(BodyPart bodyPart, String string, File file) throws MessagingException {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            SMIMEUtil.outputBodyPart(bufferedOutputStream, true, bodyPart, string);
            ((OutputStream)bufferedOutputStream).close();
            TemporaryFileInputStream temporaryFileInputStream = new TemporaryFileInputStream(file);
            return new CMSTypedStream(temporaryFileInputStream);
        }
        catch (IOException iOException) {
            throw new MessagingException("can't extract input stream: " + iOException);
        }
    }

    public SMIMESignedParser(DigestCalculatorProvider digestCalculatorProvider, MimeMultipart mimeMultipart) throws MessagingException, CMSException {
        this(digestCalculatorProvider, mimeMultipart, SMIMESignedParser.getTmpFile());
    }

    public SMIMESignedParser(DigestCalculatorProvider digestCalculatorProvider, MimeMultipart mimeMultipart, File file) throws MessagingException, CMSException {
        this(digestCalculatorProvider, mimeMultipart, "7bit", file);
    }

    public SMIMESignedParser(DigestCalculatorProvider digestCalculatorProvider, MimeMultipart mimeMultipart, String string) throws MessagingException, CMSException {
        this(digestCalculatorProvider, mimeMultipart, string, SMIMESignedParser.getTmpFile());
    }

    public SMIMESignedParser(DigestCalculatorProvider digestCalculatorProvider, MimeMultipart mimeMultipart, String string, File file) throws MessagingException, CMSException {
        super(digestCalculatorProvider, SMIMESignedParser.getSignedInputStream(mimeMultipart.getBodyPart(0), string, file), SMIMEUtil.getInputStreamNoMultipartSigned((Part)mimeMultipart.getBodyPart(1)));
        this.message = mimeMultipart;
        this.content = (MimeBodyPart)mimeMultipart.getBodyPart(0);
        this.drainContent();
    }

    public SMIMESignedParser(DigestCalculatorProvider digestCalculatorProvider, Part part) throws MessagingException, CMSException, SMIMEException {
        super(digestCalculatorProvider, SMIMEUtil.getInputStreamNoMultipartSigned(part));
        this.message = part;
        CMSTypedStream cMSTypedStream = this.getSignedContent();
        if (cMSTypedStream != null) {
            this.content = SMIMEUtil.toWriteOnceBodyPart(cMSTypedStream);
        }
    }

    public SMIMESignedParser(DigestCalculatorProvider digestCalculatorProvider, Part part, File file) throws MessagingException, CMSException, SMIMEException {
        super(digestCalculatorProvider, SMIMEUtil.getInputStreamNoMultipartSigned(part));
        this.message = part;
        CMSTypedStream cMSTypedStream = this.getSignedContent();
        if (cMSTypedStream != null) {
            this.content = SMIMEUtil.toMimeBodyPart(cMSTypedStream, file);
        }
    }

    public MimeBodyPart getContent() {
        return this.content;
    }

    public MimeMessage getContentAsMimeMessage(Session session) throws MessagingException, IOException {
        if (this.message instanceof MimeMultipart) {
            BodyPart bodyPart = ((MimeMultipart)this.message).getBodyPart(0);
            return new MimeMessage(session, bodyPart.getInputStream());
        }
        return new MimeMessage(session, this.getSignedContent().getContentStream());
    }

    public Object getContentWithSignature() {
        return this.message;
    }

    private void drainContent() throws CMSException {
        try {
            this.getSignedContent().drain();
        }
        catch (IOException iOException) {
            throw new CMSException("unable to read content for verification: " + iOException, iOException);
        }
    }

    static {
        CommandMap commandMap = CommandMap.getDefaultCommandMap();
        if (commandMap instanceof MailcapCommandMap) {
            final MailcapCommandMap mailcapCommandMap = (MailcapCommandMap)commandMap;
            mailcapCommandMap.addMailcap("application/pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_signature");
            mailcapCommandMap.addMailcap("application/pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_mime");
            mailcapCommandMap.addMailcap("application/x-pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_signature");
            mailcapCommandMap.addMailcap("application/x-pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_mime");
            mailcapCommandMap.addMailcap("multipart/signed;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.multipart_signed");
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    CommandMap.setDefaultCommandMap((CommandMap)mailcapCommandMap);
                    return null;
                }
            });
        }
    }

    private static class TemporaryFileInputStream
    extends BufferedInputStream {
        private final File _file;

        TemporaryFileInputStream(File file) throws FileNotFoundException {
            super(new FileInputStream(file));
            this._file = file;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this._file.delete();
        }
    }
}

