/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.xz;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Unpack;
import org.apache.tools.ant.util.FileUtils;
import org.tukaani.xz.XZInputStream;

public class Unxz
extends Unpack {
    private static final int BUFFER_SIZE = 8192;
    private static final String DEFAULT_EXTENSION = ".xz";

    @Override
    protected String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    @Override
    protected void extract() {
        if (this.srcResource.getLastModified() > this.dest.lastModified()) {
            this.log("Expanding " + this.srcResource.getName() + " to " + this.dest.getAbsolutePath());
            FileOutputStream out = null;
            XZInputStream zIn = null;
            InputStream fis = null;
            try {
                try {
                    out = new FileOutputStream(this.dest);
                    fis = this.srcResource.getInputStream();
                    zIn = new XZInputStream(fis);
                    byte[] buffer = new byte[8192];
                    int count = 0;
                    do {
                        out.write(buffer, 0, count);
                    } while ((count = zIn.read(buffer, 0, buffer.length)) != -1);
                }
                catch (IOException ioe) {
                    String msg = "Problem expanding xz " + ioe.getMessage();
                    throw new BuildException(msg, ioe, this.getLocation());
                }
            }
            catch (Throwable throwable) {
                FileUtils.close(fis);
                FileUtils.close(out);
                FileUtils.close(zIn);
                throw throwable;
            }
            FileUtils.close(fis);
            FileUtils.close(out);
            FileUtils.close(zIn);
        }
    }

    @Override
    protected boolean supportsNonFileResources() {
        return true;
    }
}

