/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.telnet;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.apache.commons.net.telnet.TelnetClient;

final class TelnetInputStream
extends BufferedInputStream
implements Runnable {
    private static final int EOF = -1;
    private static final int WOULD_BLOCK = -2;
    static final int STATE_DATA = 0;
    static final int STATE_IAC = 1;
    static final int STATE_WILL = 2;
    static final int STATE_WONT = 3;
    static final int STATE_DO = 4;
    static final int STATE_DONT = 5;
    static final int STATE_SB = 6;
    static final int STATE_SE = 7;
    static final int STATE_CR = 8;
    static final int STATE_IAC_SB = 9;
    private boolean hasReachedEOF;
    private volatile boolean isClosed;
    private boolean readIsWaiting;
    private int receiveState;
    private int queueHead;
    private int queueTail;
    private int bytesAvailable;
    private final int[] queue;
    private final TelnetClient client;
    private final Thread thread;
    private IOException ioException;
    private final int[] suboption;
    private int suboptionCount;
    private volatile boolean threaded;

    TelnetInputStream(InputStream input, TelnetClient client) {
        this(input, client, true);
    }

    TelnetInputStream(InputStream input, TelnetClient client, boolean readerThread) {
        super(input);
        this.client = client;
        this.receiveState = 0;
        this.isClosed = true;
        this.hasReachedEOF = false;
        this.queue = new int[2049];
        this.queueHead = 0;
        this.queueTail = 0;
        this.suboption = new int[client.maxSubnegotiationLength];
        this.bytesAvailable = 0;
        this.ioException = null;
        this.readIsWaiting = false;
        this.threaded = false;
        this.thread = readerThread ? new Thread(this) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        int[] nArray = this.queue;
        synchronized (this.queue) {
            if (this.threaded) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.bytesAvailable;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.bytesAvailable + super.available();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        super.close();
        int[] nArray = this.queue;
        synchronized (this.queue) {
            this.hasReachedEOF = true;
            this.isClosed = true;
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.interrupt();
            }
            this.queue.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processChar(int ch) throws InterruptedException {
        int[] nArray = this.queue;
        synchronized (this.queue) {
            boolean bufferWasEmpty = this.bytesAvailable == 0;
            while (this.bytesAvailable >= this.queue.length - 1) {
                if (!this.threaded) {
                    throw new IllegalStateException("Queue is full! Cannot process another character.");
                }
                this.queue.notify();
                this.queue.wait();
            }
            if (this.readIsWaiting && this.threaded) {
                this.queue.notify();
            }
            this.queue[this.queueTail] = ch;
            ++this.bytesAvailable;
            if (++this.queueTail >= this.queue.length) {
                this.queueTail = 0;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return bufferWasEmpty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read() throws IOException {
        int[] nArray = this.queue;
        synchronized (this.queue) {
            while (true) {
                int ch;
                if (this.ioException != null) {
                    IOException e = this.ioException;
                    this.ioException = null;
                    throw e;
                }
                if (this.bytesAvailable == 0) {
                    if (this.hasReachedEOF) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return -1;
                    }
                    if (this.threaded) {
                        this.queue.notify();
                        try {
                            this.readIsWaiting = true;
                            this.queue.wait();
                            this.readIsWaiting = false;
                        }
                        catch (InterruptedException e) {
                            throw new InterruptedIOException("Fatal thread interruption during read.");
                        }
                    }
                } else {
                    ch = this.queue[this.queueHead];
                    if (++this.queueHead >= this.queue.length) {
                        this.queueHead = 0;
                    }
                    --this.bytesAvailable;
                    if (this.bytesAvailable == 0 && this.threaded) {
                        this.queue.notify();
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return ch;
                }
                this.readIsWaiting = true;
                boolean mayBlock = true;
                do {
                    block25: {
                        try {
                            ch = this.read(mayBlock);
                            if (ch < 0 && ch != -2) {
                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                return ch;
                            }
                        }
                        catch (InterruptedIOException e) {
                            int[] nArray2 = this.queue;
                            synchronized (this.queue) {
                                this.ioException = e;
                                this.queue.notifyAll();
                                try {
                                    this.queue.wait(100L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                return -1;
                            }
                        }
                        try {
                            if (ch != -2) {
                                this.processChar(ch);
                            }
                        }
                        catch (InterruptedException e) {
                            if (!this.isClosed) break block25;
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return -1;
                        }
                    }
                    mayBlock = false;
                } while (super.available() > 0 && this.bytesAvailable < this.queue.length - 1);
                this.readIsWaiting = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read(boolean mayBlock) throws IOException {
        int ch;
        block48: while (true) {
            if (!mayBlock && super.available() == 0) {
                return -2;
            }
            ch = super.read();
            if (ch < 0) {
                return -1;
            }
            ch &= 0xFF;
            TelnetClient telnetClient = this.client;
            synchronized (telnetClient) {
                this.client.processAYTResponse();
            }
            this.client.spyRead(ch);
            switch (this.receiveState) {
                case 8: {
                    if (ch == 0) continue block48;
                }
                case 0: {
                    if (ch == 255) {
                        this.receiveState = 1;
                        continue block48;
                    }
                    if (ch == 13) {
                        telnetClient = this.client;
                        synchronized (telnetClient) {
                            this.receiveState = this.client.requestedDont(0) ? 8 : 0;
                            break block48;
                        }
                    }
                    this.receiveState = 0;
                    break block48;
                }
                case 1: {
                    switch (ch) {
                        case 251: {
                            this.receiveState = 2;
                            continue block48;
                        }
                        case 252: {
                            this.receiveState = 3;
                            continue block48;
                        }
                        case 253: {
                            this.receiveState = 4;
                            continue block48;
                        }
                        case 254: {
                            this.receiveState = 5;
                            continue block48;
                        }
                        case 250: {
                            this.suboptionCount = 0;
                            this.receiveState = 6;
                            continue block48;
                        }
                        case 255: {
                            this.receiveState = 0;
                            break block48;
                        }
                        case 240: {
                            this.receiveState = 0;
                            continue block48;
                        }
                    }
                    this.receiveState = 0;
                    this.client.processCommand(ch);
                    continue block48;
                }
                case 2: {
                    telnetClient = this.client;
                    synchronized (telnetClient) {
                        this.client.processWill(ch);
                        this.client.flushOutputStream();
                    }
                    this.receiveState = 0;
                    continue block48;
                }
                case 3: {
                    telnetClient = this.client;
                    synchronized (telnetClient) {
                        this.client.processWont(ch);
                        this.client.flushOutputStream();
                    }
                    this.receiveState = 0;
                    continue block48;
                }
                case 4: {
                    telnetClient = this.client;
                    synchronized (telnetClient) {
                        this.client.processDo(ch);
                        this.client.flushOutputStream();
                    }
                    this.receiveState = 0;
                    continue block48;
                }
                case 5: {
                    telnetClient = this.client;
                    synchronized (telnetClient) {
                        this.client.processDont(ch);
                        this.client.flushOutputStream();
                    }
                    this.receiveState = 0;
                    continue block48;
                }
                case 6: {
                    switch (ch) {
                        case 255: {
                            this.receiveState = 9;
                            continue block48;
                        }
                    }
                    if (this.suboptionCount < this.suboption.length) {
                        this.suboption[this.suboptionCount++] = ch;
                    }
                    this.receiveState = 6;
                    continue block48;
                }
                case 9: {
                    switch (ch) {
                        case 240: {
                            telnetClient = this.client;
                            synchronized (telnetClient) {
                                this.client.processSuboption(this.suboption, this.suboptionCount);
                                this.client.flushOutputStream();
                            }
                            this.receiveState = 0;
                            continue block48;
                        }
                        case 255: {
                            if (this.suboptionCount >= this.suboption.length) break;
                            this.suboption[this.suboptionCount++] = ch;
                            break;
                        }
                    }
                    this.receiveState = 6;
                    continue block48;
                }
            }
            break;
        }
        return ch;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (length < 1) {
            return 0;
        }
        int[] nArray = this.queue;
        synchronized (this.queue) {
            if (length > this.bytesAvailable) {
                length = this.bytesAvailable;
            }
            // ** MonitorExit[var6_4] (shouldn't be in output)
            int ch = this.read();
            if (ch == -1) {
                return -1;
            }
            int off = offset;
            do {
                buffer[offset++] = (byte)ch;
            } while (--length > 0 && (ch = this.read()) != -1);
            return offset - off;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            while (!this.isClosed) {
                int ch;
                block20: {
                    try {
                        ch = this.read(true);
                        if (ch >= 0) break block20;
                        break;
                    }
                    catch (InterruptedIOException e) {
                        block22: {
                            int[] nArray = this.queue;
                            // MONITORENTER : this.queue
                            this.ioException = e;
                            this.queue.notifyAll();
                            try {
                                this.queue.wait(100L);
                            }
                            catch (InterruptedException interrupted) {
                                if (!this.isClosed) break block22;
                                // MONITOREXIT : nArray
                                break;
                            }
                        }
                        // MONITOREXIT : nArray
                        continue;
                    }
                    catch (RuntimeException re) {
                        super.close();
                        break;
                    }
                }
                boolean notify = false;
                try {
                    notify = this.processChar(ch);
                }
                catch (InterruptedException e) {
                    if (this.isClosed) break;
                }
                if (!notify) continue;
                this.client.notifyInputListener();
            }
        }
        catch (IOException ioe) {
            int[] nArray = this.queue;
            // MONITORENTER : this.queue
            this.ioException = ioe;
            // MONITOREXIT : nArray
            this.client.notifyInputListener();
        }
        int[] nArray = this.queue;
        // MONITORENTER : this.queue
        this.isClosed = true;
        this.hasReachedEOF = true;
        this.queue.notify();
        // MONITOREXIT : nArray
        this.threaded = false;
    }

    void start() {
        if (this.thread == null) {
            return;
        }
        this.isClosed = false;
        int priority = Thread.currentThread().getPriority() + 1;
        if (priority > 10) {
            priority = 10;
        }
        this.thread.setPriority(priority);
        this.thread.setDaemon(true);
        this.thread.start();
        this.threaded = true;
    }
}

