/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.examples.unix;

import java.io.IOException;
import java.net.InetAddress;
import java.time.Duration;
import org.apache.commons.net.time.TimeTCPClient;
import org.apache.commons.net.time.TimeUDPClient;

public final class rdate {
    public static void main(String[] args) {
        if (args.length == 1) {
            try {
                rdate.timeTCP(args[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        } else if (args.length == 2 && args[0].equals("-udp")) {
            try {
                rdate.timeUDP(args[1]);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        } else {
            System.err.println("Usage: rdate [-udp] <hostname>");
            System.exit(1);
        }
    }

    public static void timeTCP(String host) throws IOException {
        TimeTCPClient client = new TimeTCPClient();
        client.setDefaultTimeout(60000);
        client.connect(host);
        System.out.println(client.getDate().toString());
        client.disconnect();
    }

    public static void timeUDP(String host) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TimeUDPClient client = new TimeUDPClient();){
            client.setDefaultTimeout(Duration.ofSeconds(60L));
            client.open();
            System.out.println(client.getDate(InetAddress.getByName(host)).toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

