/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.web.javascript;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcStreamUtil;
import jp.co.extreme.html.common.HtmlBuilder;
import jp.co.extreme.web.javascript.WbfJavaScript;

public class WbfJslUtil {
    static HtmlBuilder htmlBuilder = HtmlBuilder.getInstance();
    public static final String JS_pathBase = "ext_js/";
    public static final String JS_include = "ext_js/include/";
    public static final String JS_base = "ext_js/ext_base.js";
    public static final String JSLN_base = "base";
    public static final String JSLN_subWindow = "subWindow";
    public static final String JSLN_table = "table";
    public static final String JSLN_calendar = "calendar";
    public static final String JSLN_imageLink = "imageLink";
    public static final String JSLN_TableControl = "TableControl";
    public static final String JSN_default = "default";
    private static Properties libProps;

    private WbfJslUtil() {
    }

    public static String getResourcePath(String libName) throws Exception {
        if (libProps == null) {
            libProps = new Properties();
            libProps.setProperty(JSLN_base, "script/common.jslm");
            libProps.setProperty(JSLN_subWindow, "script/subWindow.jslm");
            libProps.setProperty(JSLN_table, "script/table.jslm");
            libProps.setProperty(JSLN_calendar, "script/calendar.jslm");
            libProps.setProperty(JSLN_imageLink, "script/imageLink.jslm");
            libProps.setProperty(JSLN_TableControl, "script/TableControl.jslm");
            libProps.setProperty(JSN_default, "script/default.js");
        }
        return libProps.getProperty(libName);
    }

    public static void restructLibraryList(List<String> libNameList) throws Exception {
        ArrayList<String> libNameList2 = new ArrayList<String>();
        int i = 0;
        while (i < libNameList.size()) {
            String libName = libNameList.get(i);
            if (!libNameList2.contains(libName)) {
                libNameList2.add(libName);
            }
            ++i;
        }
        if (!libNameList2.contains(JSLN_base)) {
            libNameList2.add(0, JSLN_base);
        }
        libNameList.clear();
        libNameList.addAll(libNameList2);
    }

    public static StringBuilder createScript(List<String> libNameList, List<String> scriptModuleList) throws Exception {
        int i;
        WbfJslUtil.restructLibraryList(libNameList);
        StringBuilder sb = new StringBuilder();
        sb.append("<script language=" + BcStringUtil.doubleQuotation("JavaScript") + ">");
        sb.append(WbfJslUtil.htmlBuilder.lineSep);
        sb.append("<!--");
        sb.append(WbfJslUtil.htmlBuilder.lineSep);
        if (scriptModuleList != null) {
            if (scriptModuleList.size() == 0) {
                String resourcePath = WbfJslUtil.getResourcePath(JSN_default);
                InputStream is = WbfJslUtil.class.getResourceAsStream(resourcePath);
                scriptModuleList.add(BcStreamUtil.readAsString(is, BcConstants.charset));
            }
            i = 0;
            while (i < scriptModuleList.size()) {
                sb.append(WbfJslUtil.htmlBuilder.lineSep);
                sb.append("//============================================================");
                sb.append(WbfJslUtil.htmlBuilder.lineSep);
                sb.append("// module : " + (i + 1));
                sb.append(WbfJslUtil.htmlBuilder.lineSep);
                sb.append("//============================================================");
                sb.append(WbfJslUtil.htmlBuilder.lineSep);
                String obj = scriptModuleList.get(i);
                if (obj.getClass().equals(String.class)) {
                    sb.append(obj);
                } else if (obj.getClass().equals(StringBuilder.class)) {
                    sb.append((CharSequence)((StringBuilder)((Object)obj)));
                } else {
                    throw new Exception("not suppoted class:" + obj.getClass().getName());
                }
                sb.append(WbfJslUtil.htmlBuilder.lineSep);
                ++i;
            }
        }
        i = 0;
        while (i < libNameList.size()) {
            String libName = libNameList.get(i);
            BcStringUtil.appendCaseOfNotEmpty(sb, WbfJslUtil.htmlBuilder.lineSep);
            sb.append("//============================================================");
            sb.append(WbfJslUtil.htmlBuilder.lineSep);
            sb.append("// " + libName);
            sb.append(WbfJslUtil.htmlBuilder.lineSep);
            sb.append("//============================================================");
            sb.append(WbfJslUtil.htmlBuilder.lineSep);
            String resourcePath = WbfJslUtil.getResourcePath(libName);
            InputStream is = WbfJslUtil.class.getResourceAsStream(resourcePath);
            sb.append(BcStreamUtil.readAsString(is, BcConstants.charset));
            sb.append(WbfJslUtil.htmlBuilder.lineSep);
            ++i;
        }
        sb.append("//-->");
        sb.append(WbfJslUtil.htmlBuilder.lineSep);
        sb.append("</script>");
        sb.append(WbfJslUtil.htmlBuilder.lineSep);
        return sb;
    }

    public static String onClick_windowClose() {
        return WbfJavaScript.onclick("window.close()");
    }

    public static String onFocus_blur(boolean editable) {
        if (editable) {
            return "";
        }
        String tmpStr = "this.blur()";
        return "onFocus=" + BcStringUtil.doubleQuotation(tmpStr);
    }

    public static String onFocus_blur() {
        return WbfJslUtil.onFocus_blur(false);
    }

    public static String onClick_link(String href, String target) {
        StringBuilder sb = new StringBuilder();
        sb.append("JavaScript:");
        if (!BcStringUtil.isEmpty(target)) {
            sb.append("parent.");
            sb.append(target);
            sb.append(".");
        }
        sb.append("location.href=");
        sb.append(BcStringUtil.singleQuotation(href));
        return WbfJavaScript.onclick(sb.toString());
    }

    public static String onClick_link(String href) {
        return WbfJslUtil.onClick_link(href, null);
    }

    public static String locationHref(String href) {
        StringBuilder sb = new StringBuilder();
        sb.append("location.href=");
        sb.append(BcStringUtil.singleQuotation(href));
        return sb.toString();
    }

    public static String jsfn_alert(String msg) throws Exception {
        String tmpStr = "jsfn_alert(" + BcStringUtil.singleQuotation(msg) + ")";
        return tmpStr;
    }

    public static String submit(String formName) {
        String tmpStr = "jsfn_submit(" + formName + ")";
        return tmpStr;
    }

    public static String submit2(String formName, String url) {
        String tmpStr = "jsfn_submit2(" + formName + ", " + BcStringUtil.singleQuotation(url) + ")";
        return tmpStr;
    }

    public static String submit3(String formName, String url, String element, Object value) {
        String tmpStr = "jsfn_submit3(" + formName + ", " + BcStringUtil.singleQuotation(url) + ", " + element + ", " + BcStringUtil.singleQuotation(value) + ")";
        return tmpStr;
    }

    public static String onClick_submit3(String form, String url, String element, Object value) {
        return WbfJavaScript.onclick(WbfJslUtil.submit3(form, url, element, value));
    }

    public static String onClick_submit2(String form, String url) {
        return WbfJavaScript.onclick(WbfJslUtil.submit2(form, url));
    }

    public static String onClick_submit(String form) {
        return WbfJavaScript.onclick(WbfJslUtil.submit(form));
    }

    public static String onClick_setElementValueAndSubmit(String element, String value) throws Exception {
        String tmpStr = "jsfn_setElementValueAndSubmit(" + element + ", " + BcStringUtil.singleQuotation(value) + ")";
        return "onClick=" + BcStringUtil.doubleQuotation(tmpStr);
    }

    public static String onClick_openSubWindow(String url, String title, String subWinParam) {
        String tmpStr = "jsfn_openSubWindow(" + BcStringUtil.singleQuotation(url) + ", " + BcStringUtil.singleQuotation(title) + ", " + BcStringUtil.singleQuotation(subWinParam) + ")";
        return "onClick=" + BcStringUtil.doubleQuotation(tmpStr);
    }

    public static String onClick_openSubWindow(String url, String title, String subWinParam, String formElement) {
        String tmpStr = "jsfn_openSubWindow2(" + BcStringUtil.singleQuotation(url) + ", " + BcStringUtil.singleQuotation(title) + ", " + BcStringUtil.singleQuotation(subWinParam) + ", " + formElement + ")";
        return "onClick=" + BcStringUtil.doubleQuotation(tmpStr);
    }

    public static String onClick_setTablePageSeq(String form, String handleId, int pageSeq) {
        String tmpStr = "jsfn_setTablePageSeq(" + form + ", " + BcStringUtil.singleQuotation(handleId) + ", " + Integer.toString(pageSeq) + ")";
        return "onClick=" + BcStringUtil.doubleQuotation(tmpStr);
    }

    public static String onClick_calendar(String formElement) {
        String tmpStr = "jsfn_calendar(" + formElement + ", " + "event" + ")";
        return "onClick=" + BcStringUtil.doubleQuotation(tmpStr);
    }

    public static String onMouseImage(String objectName, String res1Url, String res2Url) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("onMouseOver=");
        String tmpStr = "jsfn_setImage3(" + BcStringUtil.singleQuotation(objectName) + ", " + BcStringUtil.singleQuotation(res2Url) + ")";
        sb.append(BcStringUtil.doubleQuotation(tmpStr));
        sb.append(" ");
        sb.append("onMouseOut=");
        tmpStr = "jsfn_setImage3(" + BcStringUtil.singleQuotation(objectName) + ", " + BcStringUtil.singleQuotation(res1Url) + ")";
        sb.append(BcStringUtil.doubleQuotation(tmpStr));
        return sb.toString();
    }

    public static String onMouseImage2(String objectName, String res1Url, String res2Url) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("onMouseOver=");
        String tmpStr = String.valueOf(objectName) + ".src=" + BcStringUtil.singleQuotation(res2Url);
        sb.append(BcStringUtil.doubleQuotation(tmpStr));
        sb.append(" ");
        sb.append("onMouseOut=");
        tmpStr = String.valueOf(objectName) + ".src=" + BcStringUtil.singleQuotation(res1Url);
        sb.append(BcStringUtil.doubleQuotation(tmpStr));
        return sb.toString();
    }
}

