/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsys.validation;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcReflectUtil;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.module.mmdx.common.MmdxUtil;
import jp.co.extreme.module.xsys.validation.XsysFieldKeyCreator;
import jp.co.extreme.module.xsys.validation.XsysValidationElement;
import jp.co.extreme.module.xsys.validation.XsysValidationResult;

public class XsysValidator
extends BcLoggableObject {
    public static XsysValidator getInstance() {
        return SingletonHolder.instance;
    }

    public XsysValidationResult validate(Object entity) throws Exception {
        String entityName = entity.getClass().getSimpleName();
        return this.validate(entity, entityName);
    }

    protected XsysValidationResult validate(Object entity, String entityName) throws Exception {
        XsysValidationResult validationResult = new XsysValidationResult();
        Class<?> entityClass = entity.getClass();
        List<Map.Entry<Field, MmdField>> mapEntryList1 = MmdxUtil.createFieldEntryList(entityClass);
        int i = 0;
        while (i < mapEntryList1.size()) {
            Object fieldValue;
            MmdField mmdField;
            Map.Entry<Field, MmdField> mapEntry = mapEntryList1.get(i);
            Field field = mapEntry.getKey();
            List msgList = this.validate(entity, field, mmdField = mapEntry.getValue(), fieldValue = BcReflectUtil.getFieldValue(field, entity));
            if (!BcCollectionUtil.isEmpty(msgList)) {
                String key = XsysFieldKeyCreator.getInstance().createKey(entityName, mmdField.fieldName);
                XsysValidationElement validationElement = new XsysValidationElement();
                validationElement.field = field;
                validationElement.mmdField = mmdField;
                validationElement.value = fieldValue;
                validationElement.msgList = msgList;
                validationResult.fieldErrMap.put(key, validationElement);
            }
            ++i;
        }
        return validationResult;
    }

    protected List validate(Object entity, Field field, MmdField mmdField, Object fieldValue) throws Exception {
        Pattern pattern;
        Matcher matcher;
        ArrayList<String> msgList = new ArrayList<String>();
        if (mmdField.required) {
            if (BcStringUtil.isEmpty(fieldValue)) {
                msgList.add(BcWords.getInstance().$_is_required(BcStringUtil.singleQuotation(mmdField.fieldDisplay.displayName)));
            }
            return msgList;
        }
        String strValue = BcStringUtil.toStringNotNull(fieldValue);
        if (mmdField.dataSize > 0 && strValue.length() > mmdField.dataSize) {
            msgList.add(String.format("\u6700\u5927 %d \u6587\u5b57\u3067\u3059\u3002", mmdField.dataSize));
        }
        if (!BcStringUtil.isEmpty(mmdField.inputPattern) && !(matcher = (pattern = Pattern.compile(mmdField.inputPattern)).matcher(strValue)).matches()) {
            msgList.add(this.createPatternUnmatchMessage(entity, field, mmdField, fieldValue));
        }
        return msgList;
    }

    protected String createPatternUnmatchMessage(Object entity, Field field, MmdField mmdField, Object fieldValue) throws Exception {
        return "\u30d1\u30bf\u30fc\u30f3\u306b\u5408\u81f4\u3057\u307e\u305b\u3093\u3002" + mmdField.inputPattern;
    }

    public BcResult validateForGui(Object entity) throws Exception {
        XsysValidationResult validationResult = this.validate(entity);
        return this.inputErrorPreprocessing(validationResult);
    }

    public BcResult inputErrorPreprocessing(XsysValidationResult validationResult) throws Exception {
        BcResult result = new BcResult();
        for (Map.Entry<String, XsysValidationElement> mapEntry : validationResult.fieldErrMap.entrySet()) {
            this.getLogger().debug("key=" + mapEntry.getKey());
            XsysValidationElement validationElement = mapEntry.getValue();
            result.getErrorList().addAll(validationElement.msgList);
        }
        return result;
    }

    private static final class SingletonHolder {
        private static final XsysValidator instance = new XsysValidator();

        private SingletonHolder() {
        }
    }
}

