/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcUnicode;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdIndex;
import jp.co.extreme.base.mmd.MmdIndexElement;
import jp.co.extreme.base.mmd.MmdModel;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.util.BcCloneUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcCsvUtil;
import jp.co.extreme.base.util.BcRegexUtil;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.datasource.util.DtsWordManager;
import jp.co.extreme.html.util.EtcHtmlUtil;
import jp.co.extreme.html.util.HtmlToPlain;
import jp.co.extreme.module.mmdx.common.MmdxConstants;
import jp.co.extreme.module.mmdx.model.MmdxField;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.module.xdts.model.XdtsSchemaObject;
import jp.co.extreme.module.xdts.model.XdtsUserSetting;
import jp.co.extreme.module.xdts.model.v001.XdtsControlContext;
import jp.co.extreme.module.xdts.model.v001.XdtsExtractionCondition;
import jp.co.extreme.module.xdts.model.v001.XdtsSelect;
import jp.co.extreme.scf.scheduler.ScfSchedulerWords;
import jp.co.extreme.sql.SqlDefinitionCondition;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.SqlWords;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;

public final class XdtsUtil {
    static HtmlToPlain htmlToPlain = new HtmlToPlain();

    private XdtsUtil() {
    }

    public static List<XdtsSchemaObject> toSchemaObjectList(List<String> objectNameList, XdtsConstants.SchemaObjectType schemaObjectType, boolean enabled) throws Exception {
        ArrayList<XdtsSchemaObject> schemaObjectList = new ArrayList<XdtsSchemaObject>();
        int i = 0;
        while (i < objectNameList.size()) {
            XdtsSchemaObject schemaObject = new XdtsSchemaObject();
            schemaObject.schemaObjectType = schemaObjectType;
            schemaObject.name1 = objectNameList.get(i);
            schemaObject.enabled = enabled;
            schemaObjectList.add(schemaObject);
            ++i;
        }
        return schemaObjectList;
    }

    public static List<XdtsSchemaObject> toSchemaObjectList(XdtsConstants.SchemaObjectType schemaObjectType, boolean enabled, String ... shemaObjectNames) throws Exception {
        ArrayList<String> objectNameList = new ArrayList<String>();
        int i = 0;
        while (i < shemaObjectNames.length) {
            objectNameList.add(shemaObjectNames[i]);
            ++i;
        }
        return XdtsUtil.toSchemaObjectList(objectNameList, schemaObjectType, enabled);
    }

    public static BcTableColumnModel createDataSourceTableColumnModel(boolean dataSourceIdVisible) throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = EtcHtmlUtil.toHtml(XdtsWords.getInstance().dataSourceId);
        mmdField.dataClass = Long.class;
        mmdField.columnCount = 8;
        tableColumn.setMmdField(mmdField);
        tableColumn.setVisible(dataSourceIdVisible);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = SqlWords.getInstance().dataSourceName;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 20;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = XdtsWords.getInstance().product;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 10;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = BcWords.getInstance().url;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 60;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = BcWords.getInstance().user;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 12;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = BcWords.getInstance().note;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 20;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        return tableColumnModel;
    }

    public static List<String> toNameList(List<XdtsSchemaObject> schemaObjectList) throws Exception {
        ArrayList<String> nameList = new ArrayList<String>();
        int i = 0;
        while (i < schemaObjectList.size()) {
            XdtsSchemaObject schemaObject = schemaObjectList.get(i);
            nameList.add(schemaObject.name1);
            ++i;
        }
        return nameList;
    }

    public static BcTableColumnModel createColumnDefineTableColumnModel() throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.columnName = BcWords.getInstance().ordinalPosition.toPlain();
        mmdField.fieldDisplay.displayName = EtcHtmlUtil.toHtml(BcWords.getInstance().ordinalPosition);
        mmdField.dataClass = Integer.class;
        mmdField.columnCount = 8;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.tableColumnName = MmdxConstants.TableColmnName.mdx_field__column_name.value;
        mmdField.columnName = BcWords.getInstance().columnName;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 24;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.columnName = SqlWords.getInstance().jdbcType;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 16;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.columnName = BcWords.getInstance().size;
        mmdField.dataClass = Integer.class;
        mmdField.columnCount = 10;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.columnName = BcWords.getInstance().decimalDigit.toPlain();
        mmdField.fieldDisplay.displayName = EtcHtmlUtil.toHtml(BcWords.getInstance().decimalDigit);
        mmdField.dataClass = Integer.class;
        mmdField.columnCount = 6;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.columnName = BcWords.getInstance().nullable;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 7;
        mmdField.fieldDisplay.horizonalAlignment = 0;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.columnName = BcWords.getInstance().logicalName;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 20;
        mmdField.fieldDisplay.horizonalAlignment = 2;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.columnName = BcWords.getInstance().tableName;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 20;
        mmdField.fieldDisplay.horizonalAlignment = 2;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        return tableColumnModel;
    }

    public static BcTableColumnModel createCustomQueryTableColumnModel() throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = "\u30b3\u30fc\u30c9";
        mmdField.dataClass = Integer.class;
        mmdField.columnCount = 16;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = "\u30af\u30a8\u30ea";
        mmdField.dataClass = String.class;
        mmdField.columnCount = 16;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = "\u5099\u8003";
        mmdField.dataClass = String.class;
        mmdField.columnCount = 20;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = "\u767b\u9332\u65e5\u6642";
        mmdField.dataClass = String.class;
        mmdField.columnCount = 6;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        return tableColumnModel;
    }

    public static BcTableColumnModel createWordTableColumnModel() throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = "<html><center>" + BcWords.getInstance().physicalName + "</center></html>";
        mmdField.dataClass = String.class;
        mmdField.columnCount = 32;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = "<html><center>" + BcWords.getInstance().language + "</center></html>";
        mmdField.dataClass = String.class;
        mmdField.columnCount = 4;
        mmdField.fieldDisplay.horizonalAlignment = 0;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = "<html><center>" + BcWords.getInstance().logicalName + "</center></html>";
        mmdField.dataClass = String.class;
        mmdField.columnCount = 60;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = BcWords.getInstance().note;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 20;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        return tableColumnModel;
    }

    public static BcTableColumnModel createTimerTableColumnModel() throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = XdtsWords.getInstance().timerName;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 16;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = String.valueOf(BcWords.getInstance().start) + " " + BcWords.getInstance().dateTime;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 17;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = ScfSchedulerWords.getInstance().trigger;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 8;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = String.valueOf(BcWords.getInstance().value) + " 1";
        mmdField.dataClass = String.class;
        mmdField.columnCount = 10;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = String.valueOf(BcWords.getInstance().value) + " 2";
        mmdField.dataClass = String.class;
        mmdField.columnCount = 10;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = String.valueOf(BcWords.getInstance().value) + " 3";
        mmdField.dataClass = String.class;
        mmdField.columnCount = 10;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        return tableColumnModel;
    }

    public static String createColumnName(int columnNum) throws Exception {
        return "column_" + columnNum;
    }

    public static String toDbObjectName(String src) throws Exception {
        String tmpStr = BcStringUtil.toLatinBasic(src, 2);
        tmpStr = BcStringUtil.replace((CharSequence)tmpStr, BcStringUtil.SPACE_STR, BcStringUtil.UNDER_SCORE_STR).toString();
        tmpStr = BcStringUtil.replace((CharSequence)tmpStr, BcUnicode.FULLWIDTH_SPACE.string, BcStringUtil.UNDER_SCORE_STR).toString();
        return tmpStr.toString();
    }

    public static BcTableColumnModel createSizeTableColumnModel() throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = BcWords.getInstance().tableName;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 40;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = EtcHtmlUtil.toHtml(BcWords.getInstance().numberOfRows);
        mmdField.dataClass = Long.class;
        mmdField.columnCount = 12;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        return tableColumnModel;
    }

    public static String apendLogicalName(DtsWordManager wordManager, String physicalName) {
        StringBuilder sb = new StringBuilder();
        sb.append(physicalName);
        String logicalName = wordManager.getWord(physicalName.toString(), Locale.getDefault().getLanguage());
        if (!BcStringUtil.isEmpty(logicalName)) {
            sb.append(" ");
            sb.append(logicalName);
        }
        return sb.toString();
    }

    public static String getLogicalName(String tableName, MmdxField mmdxField, DtsWordManager wordManager) throws Exception {
        if (wordManager == null) {
            return null;
        }
        String logicalName = null;
        if (!BcStringUtil.isEmpty(mmdxField.wordCode)) {
            logicalName = wordManager.getWord(mmdxField.wordCode, Locale.getDefault().getLanguage());
        }
        if (BcStringUtil.isEmpty(logicalName)) {
            String tableColumnName = MmdUtil.createTableColumnName(tableName, mmdxField.columnName);
            logicalName = wordManager.getWord(tableColumnName, Locale.getDefault().getLanguage());
        }
        logicalName = htmlToPlain.toPlain(logicalName).toString();
        return logicalName;
    }

    public static String getDefaultValue(XdtsControlContext controlContext, XdtsUserSetting userSetting) throws Exception {
        String defaultValue = null;
        if (BcCollectionUtil.isEmpty(controlContext.inputValueList)) {
            defaultValue = controlContext.defaultValue;
            if (!BcStringUtil.isEmpty(controlContext.name) && userSetting != null && userSetting.map.containsKey(controlContext.name)) {
                defaultValue = userSetting.map.get(controlContext.name);
            }
        } else {
            defaultValue = BcCollectionUtil.getLast(controlContext.inputValueList);
        }
        return defaultValue;
    }

    public static List<String> createOptionList(XdtsControlContext controlContext) throws Exception {
        List<String> optionList = BcCsvUtil.parseCsvRow(controlContext.options, true);
        if (!BcCollectionUtil.isEmpty(optionList)) {
            return XdtsUtil.trim(optionList);
        }
        if (!BcCollectionUtil.isEmpty(controlContext.inputValueList)) {
            for (String value : controlContext.inputValueList) {
                if (BcStringUtil.isEmpty(value = BcStringUtil.trim(value)) || optionList.contains(value)) continue;
                optionList.add(value);
            }
        }
        return optionList;
    }

    public static List<String> trim(List<String> strList) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        for (String str : strList) {
            str = BcStringUtil.trim(str);
            list.add(str);
        }
        return list;
    }

    public static BcResult validateSql(String sql, boolean pluralOk) throws Exception {
        BcResult result = new BcResult();
        List<String> statementList = SqlUtil.toStatementList(sql);
        if (BcCollectionUtil.isEmpty(statementList)) {
            result.addError(XdtsWords.getInstance().\u30b9\u30c6\u30fc\u30c8\u30e1\u30f3\u30c8\u304c\u691c\u51fa\u3067\u307e\u305b\u3093);
        }
        if (!pluralOk && BcCollectionUtil.getSize(statementList) > 1) {
            result.addError(XdtsWords.getInstance().\u30b9\u30c6\u30fc\u30c8\u30e1\u30f3\u30c8\u304c\u8907\u6570\u3067\u3059);
        }
        return result;
    }

    public static String reformPath(String src) throws Exception {
        if (BcStringUtil.isEmpty(src)) {
            return null;
        }
        String strWk = XdtsUtil.temp1(src);
        String[] elemnts = BcStringUtil.split(strWk, BcRegexUtil.escapEncode(BcStringUtil.SLASH_STR));
        ArrayList<String> list = new ArrayList<String>();
        int j = 0;
        while (j < elemnts.length) {
            String elemnt = elemnts[j];
            if (!BcStringUtil.isEmpty(elemnt = BcStringUtil.trim(elemnt))) {
                list.add(elemnt);
            }
            ++j;
        }
        strWk = BcStringUtil.marge(list, BcStringUtil.SLASH_STR).toString();
        if (BcStringUtil.isEmpty(strWk)) {
            return null;
        }
        return strWk;
    }

    public static String deleteFirst(String str) throws Exception {
        return str.substring(1);
    }

    public static String deleteLast(String str) throws Exception {
        return str.substring(0, str.length() - 1);
    }

    public static String temp1(String src) throws Exception {
        String strWk = BcStringUtil.trim(src);
        while (strWk.startsWith(BcStringUtil.SLASH_STR)) {
            strWk = XdtsUtil.deleteFirst(strWk);
            strWk = BcStringUtil.trim(strWk);
        }
        while (strWk.endsWith(BcStringUtil.SLASH_STR)) {
            strWk = XdtsUtil.deleteLast(strWk);
            strWk = BcStringUtil.trim(strWk);
        }
        return strWk;
    }

    public static void addEntry(String key, String value, XdtsUserSetting userSetting) throws Exception {
        if (userSetting != null) {
            userSetting.addEntry(key, value);
        }
    }

    public static List<String> createRemoveFieldNameList(SqlContext sqlContext, MmdModel mmdModel, SqlDefinitionCondition definitionCondition) throws Exception {
        ArrayList<String> removeFieldNameList = new ArrayList<String>();
        int fieldCount = mmdModel.getFieldCount();
        int i = 0;
        while (i < fieldCount) {
            MmdField mmdField = mmdModel.getField(i);
            String definition = sqlContext.createColumnTypeDefinition(mmdField, definitionCondition);
            if (BcStringUtil.isEmpty(definition)) {
                removeFieldNameList.add(BcStringUtil.toLowerCase(mmdField.columnName));
            }
            ++i;
        }
        return removeFieldNameList;
    }

    public static void removeField(MmdModel mmdModel, List<String> removeFieldNameList, boolean renumber, BcLogger logger) throws Exception {
        Object mmdField;
        ArrayList<MmdField> removeFieldList = new ArrayList<MmdField>();
        int fieldCount = mmdModel.getFieldCount();
        int i = 0;
        while (i < fieldCount) {
            int index = fieldCount - i - 1;
            mmdField = mmdModel.getField(index);
            if (BcStringUtil.containsIgnoreCase(removeFieldNameList, ((MmdField)mmdField).columnName)) {
                removeFieldList.add((MmdField)mmdField);
                logger.info("\u8907\u5199\u5bfe\u8c61\u5916:" + ((MmdField)mmdField).tableColumnName + " sqlTypeId=" + ((MmdField)mmdField).sqlTypeId + " size=" + ((MmdField)mmdField).dataSize + " decimalDigit=" + ((MmdField)mmdField).decimalDigit);
            }
            ++i;
        }
        logger.info("\u8907\u5199\u5bfe\u8c61\u5916\u306e\u5217\u6570=" + removeFieldList.size());
        ArrayList<MmdIndex> removeIndexList = new ArrayList<MmdIndex>();
        for (MmdIndex mmdIndex : mmdModel.indexMap.values()) {
            int i2 = 0;
            while (i2 < mmdIndex.indexElementList.size()) {
                MmdIndexElement indexElement = mmdIndex.indexElementList.get(i2);
                int j = 0;
                while (j < removeFieldList.size()) {
                    MmdField mmdField2 = (MmdField)removeFieldList.get(j);
                    if (indexElement.columnName.equalsIgnoreCase(mmdField2.columnName)) {
                        removeIndexList.add(mmdIndex);
                        break;
                    }
                    ++j;
                }
                ++i2;
            }
        }
        int i3 = 0;
        while (i3 < removeIndexList.size()) {
            MmdIndex mmdIndex1 = (MmdIndex)removeIndexList.get(i3);
            MmdIndex mmdIndex2 = mmdModel.indexMap.remove(mmdIndex1.name);
            if (mmdIndex2 == null) {
                throw new Exception("mmdIndex2=" + mmdIndex2);
            }
            if (mmdIndex1.name.equalsIgnoreCase(mmdModel.primaryIndexName)) {
                mmdModel.primaryIndexName = null;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < removeFieldList.size()) {
            mmdField = (MmdField)removeFieldList.get(i3);
            mmdModel.removeField(((MmdField)mmdField).ordinalPosition - 1);
            ++i3;
        }
        if (renumber) {
            i3 = 0;
            while (i3 < mmdModel.getFieldCount()) {
                mmdField = mmdModel.getField(i3);
                ((MmdField)mmdField).ordinalPosition = i3 + 1;
                ++i3;
            }
        }
    }

    public static void controlFidden(XdtsExtractionCondition extractionCondition) throws Exception {
        int i = 0;
        while (i < extractionCondition.selectList.size()) {
            XdtsSelect sdtsSelect = extractionCondition.selectList.get(i);
            if (sdtsSelect.id != 0) {
                int j = 0;
                while (j < sdtsSelect.controlContextList.size()) {
                    XdtsControlContext controlContext = sdtsSelect.controlContextList.get(j);
                    controlContext.displayOrder = -1;
                    ++j;
                }
            }
            ++i;
        }
    }

    public static String createInfo(XdtsExtractionCondition extractionCondition) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("selectList.size()=" + extractionCondition.selectList.size() + "\n");
        int i = 0;
        while (i < extractionCondition.selectList.size()) {
            XdtsSelect xdtsSelect = extractionCondition.selectList.get(i);
            sb.append("  xdtsSelect.id=" + xdtsSelect.id + "\n");
            sb.append("    controlContextList.size()=" + xdtsSelect.controlContextList.size() + "\n");
            int j = 0;
            while (j < xdtsSelect.controlContextList.size()) {
                XdtsControlContext controlContext = xdtsSelect.controlContextList.get(j);
                sb.append("    controlContext.contextType=" + (Object)((Object)controlContext.contextType) + " controlContext.name=" + controlContext.name + " displayOrder=" + controlContext.displayOrder + "\n");
                ++j;
            }
            ++i;
        }
        return sb.toString();
    }

    public static Map<String, String> renameReservedName(SqlContext sqlContext, MmdModel mmdModel) throws Exception {
        HashMap<String, String> nameMap = new HashMap<String, String>();
        if (sqlContext.isReservedWord(mmdModel.tableName)) {
            String newName = XdtsUtil.renameReservedName(mmdModel.tableName);
            nameMap.put(mmdModel.tableName, newName);
            mmdModel.tableName = newName;
        }
        int i = 0;
        while (i < mmdModel.getFieldCount()) {
            MmdField mmdField = mmdModel.getField(i);
            if (sqlContext.isReservedWord(mmdField.columnName)) {
                String newName = XdtsUtil.renameReservedName(mmdField.columnName);
                nameMap.put(mmdField.columnName, newName);
                mmdField.columnName = newName;
            }
            ++i;
        }
        return nameMap;
    }

    public static String renameReservedName(String name) throws Exception {
        return String.valueOf(name) + "_";
    }

    public static void renumbeField(MmdModel mmdModel1, List<String> fieldNameList) throws Exception {
        MmdModel mmdModel2 = BcCloneUtil.createClone(mmdModel1);
        int i = 0;
        while (i < mmdModel1.getFieldCount()) {
            MmdField mmdField = mmdModel1.getField(i);
            mmdModel2.addField(mmdField);
            ++i;
        }
        mmdModel1.fieldList.clear();
        i = 0;
        while (i < fieldNameList.size()) {
            String fieldName = fieldNameList.get(i);
            MmdField mmdField = mmdModel2.getFieldByColumnName(fieldName);
            mmdModel1.addField(mmdField);
            ++i;
        }
        if (mmdModel1.getFieldCount() != fieldNameList.size()) {
            throw new Exception("mmdModel1.getFieldCount()=" + mmdModel1.getFieldCount() + " fieldNameList.size()=" + fieldNameList.size());
        }
    }

    public static void setOption(SqlSelectQuery selectQuery) throws Exception {
        selectQuery.rowLimit = 1000L;
    }
}

