/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.server;

import java.io.File;
import java.nio.file.attribute.FileAttribute;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.httpserver.HtsvSiteContext;

public class ArticleManager
extends BcLoggableObject {
    public static ArticleManager getInstance() {
        return SingletonHolder.instance;
    }

    public File getDir(HtsvSiteContext siteContext, long articleId, boolean doCreate) throws Exception {
        String dirName = "article_" + BcStringUtil.fillPrefix(articleId, 8);
        File dir = new File(siteContext.getDatasourceDir(), dirName);
        BcFileUtil.mkdirs(dir, new FileAttribute[0]);
        return dir;
    }

    public File getFilesDir(HtsvSiteContext siteContext) throws Exception {
        String dirName = "files";
        File dir = new File(siteContext.getDatasourceDir(), dirName);
        BcFileUtil.mkdirs(dir, new FileAttribute[0]);
        return dir;
    }

    private static final class SingletonHolder {
        private static final ArticleManager instance = new ArticleManager();

        private SingletonHolder() {
        }
    }
}

