/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.control;

import java.math.BigDecimal;
import javafx.geometry.Pos;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.fx.control.FxTextField;

public class FxNumberField
extends FxTextField {
    protected int integerPartDigits;
    private int decimalDigits;
    protected int roundingMode = 4;
    public boolean nullable;
    private Number defauleValue = 0;

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public void setDecimalDigits(int decimalDigits) {
        this.decimalDigits = decimalDigits;
    }

    public FxNumberField(int integerPartDigits, int decimalDigits, boolean nullable) {
        this.integerPartDigits = integerPartDigits;
        this.decimalDigits = decimalDigits;
        this.nullable = nullable;
        this.setAlignment(Pos.CENTER_RIGHT);
    }

    public FxNumberField() {
        this.setAlignment(Pos.CENTER_RIGHT);
    }

    @Override
    public void textEdited() {
        if (BcStringUtil.isEmpty(this.getText())) {
            if (!this.nullable) {
                BigDecimal bigDecimal = new BigDecimal(this.defauleValue.toString());
                this.setValue(bigDecimal);
            }
            return;
        }
        try {
            BigDecimal bigDecimal = BcNumberUtil.toBigDecimal2(this.getText(), this.integerPartDigits, this.decimalDigits, this.roundingMode);
            this.setValue(bigDecimal);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            super.setText(null);
        }
    }

    public BigDecimal getBigDecimal() {
        BigDecimal bigDecimal = null;
        if (!BcStringUtil.isEmpty(this.getText())) {
            bigDecimal = new BigDecimal(this.getText());
        }
        return bigDecimal;
    }

    public void setValue(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            this.setText(null);
        } else {
            this.setText(bigDecimal.toString());
        }
    }

    public void setValue(Number number) {
        BigDecimal bigDecimal2 = null;
        if (number != null) {
            bigDecimal2 = new BigDecimal(number.toString());
        }
        this.setValue(bigDecimal2);
    }
}

