/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.examples.mail;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.net.examples.mail.Utils;
import org.apache.commons.net.pop3.POP3Client;
import org.apache.commons.net.pop3.POP3MessageInfo;
import org.apache.commons.net.pop3.POP3SClient;

public final class POP3ExportMbox {
    private static final Pattern PATFROM = Pattern.compile(">*From ");

    public static void main(String[] args) {
        POP3Client pop3;
        boolean implicit;
        String file = null;
        int argIdx = 0;
        while (argIdx < args.length) {
            if (!args[argIdx].equals("-F")) break;
            file = args[++argIdx];
            ++argIdx;
        }
        int argCount = args.length - argIdx;
        if (argCount < 3) {
            System.err.println("Usage: POP3Mail [-F file/directory] <server[:port]> <user> <password|-|*|VARNAME> [TLS [true=implicit]]");
            System.exit(1);
        }
        String[] arg0 = args[argIdx++].split(":");
        String server = arg0[0];
        String user = args[argIdx++];
        String password = args[argIdx++];
        try {
            password = Utils.getPassword(user, password);
        }
        catch (IOException e1) {
            System.err.println("Could not retrieve password: " + e1.getMessage());
            return;
        }
        String proto = argCount > 3 ? args[argIdx++] : null;
        boolean bl = implicit = argCount > 4 && Boolean.parseBoolean(args[argIdx++]);
        if (proto != null) {
            System.out.println("Using secure protocol: " + proto);
            pop3 = new POP3SClient(proto, implicit);
        } else {
            pop3 = new POP3Client();
        }
        int port = arg0.length == 2 ? Integer.parseInt(arg0[1]) : pop3.getDefaultPort();
        System.out.println("Connecting to server " + server + " on " + port);
        pop3.setDefaultTimeout(60000);
        try {
            pop3.connect(server);
        }
        catch (IOException e) {
            System.err.println("Could not connect to server.");
            e.printStackTrace();
            return;
        }
        try {
            if (!pop3.login(user, password)) {
                System.err.println("Could not login to server.  Check password.");
                pop3.disconnect();
                return;
            }
            POP3MessageInfo status = pop3.status();
            if (status == null) {
                System.err.println("Could not retrieve status.");
                pop3.logout();
                pop3.disconnect();
                return;
            }
            System.out.println("Status: " + status);
            int count = status.number;
            if (file != null) {
                System.out.println("Getting messages: " + count);
                File mbox = new File(file);
                if (mbox.isDirectory()) {
                    System.out.println("Writing dir: " + mbox);
                    int i = 1;
                    while (i <= count) {
                        Throwable throwable = null;
                        Object var17_25 = null;
                        try (OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(mbox, String.valueOf(i) + ".eml")), StandardCharsets.ISO_8859_1);){
                            POP3ExportMbox.writeFile(pop3, fw, i);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        ++i;
                    }
                } else {
                    System.out.println("Writing file: " + mbox);
                    Throwable throwable = null;
                    Object var16_23 = null;
                    try (OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(mbox), StandardCharsets.ISO_8859_1);){
                        int i = 1;
                        while (i <= count) {
                            POP3ExportMbox.writeMbox(pop3, fw, i);
                            ++i;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
            }
            pop3.logout();
            pop3.disconnect();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean startsWith(String input, Pattern pat) {
        Matcher m = pat.matcher(input);
        return m.lookingAt();
    }

    private static void writeFile(POP3Client pop3, OutputStreamWriter fw, int i) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader r = (BufferedReader)pop3.retrieveMessage(i);){
            String line;
            while ((line = r.readLine()) != null) {
                fw.write(line);
                fw.write("\n");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void writeMbox(POP3Client pop3, OutputStreamWriter fw, int i) throws IOException {
        SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy");
        String replyTo = "MAILER-DAEMON";
        Date received = new Date();
        Throwable throwable = null;
        Object var7_8 = null;
        try (BufferedReader r = (BufferedReader)pop3.retrieveMessage(i);){
            String line;
            fw.append("From ");
            fw.append("MAILER-DAEMON");
            fw.append(' ');
            fw.append(DATE_FORMAT.format(received));
            fw.append("\n");
            while ((line = r.readLine()) != null) {
                if (POP3ExportMbox.startsWith(line, PATFROM)) {
                    fw.write(">");
                }
                fw.write(line);
                fw.write("\n");
            }
            fw.write("\n");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

