/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf8.swg;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import jp.co.extreme.awt.AwtImageHelper;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.thread.BcMonitor;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.scf.client.ScfClientContainer;
import jp.co.extreme.scf6.client.RmiTableLoader;
import jp.co.extreme.scf8.model.KscfQueryColumn;
import jp.co.extreme.scf8.rmo.KscfQueryColumnRMO;
import jp.co.extreme.scf8.stub.KscfQueryColumnStub;
import jp.co.extreme.swing.SwgDecoratePanel;
import jp.co.extreme.swing.SwgDialog;
import jp.co.extreme.swing.SwgTableView;
import jp.co.extreme.swing.SwgUtil;

public class KswgQueryColumnListPanel
extends SwgDecoratePanel {
    private static final long serialVersionUID = 3055295059394074892L;
    public int queryId;
    protected BcTableModel tableModel;
    protected SwgTableView tableView;
    protected JScrollPane tableScrollPane = new JScrollPane();
    protected Window window;

    public KswgQueryColumnListPanel() throws Exception {
        this.setLine();
        this.setOkButton(BcWords.getInstance().completion);
        this.setCancelButton(BcWords.getInstance().cancel);
    }

    protected void init() throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(KscfQueryColumnRMO.class.getName());
        rmiReq.setMethodName("queryColumnList");
        rmiReq.addData(this.queryId);
        RmiTableLoader tableLoader = new RmiTableLoader(ScfClientContainer.getInstance().getAgent());
        this.tableModel = new BcTableModel();
        BcMonitor mon = new BcMonitor();
        tableLoader.loadTable(this.tableModel, null, rmiReq, mon);
        mon.sync();
        BcTableColumn tableColumn = this.tableModel.getTableColumnModel().getColumn("frwk_query_column.view_index");
        tableColumn.isEditable = true;
        this.tableView = new SwgTableView(this.tableModel, this.tableModel.getTableColumnModel());
        this.tableScrollPane.getViewport().add(this.tableView);
        this.centerPanel.setLayout(new BorderLayout());
        this.centerPanel.add((Component)this.tableScrollPane, "Center");
    }

    @Override
    protected void okButtonAction() throws Exception {
        ArrayList<KscfQueryColumn> queryColumnList = new ArrayList<KscfQueryColumn>();
        int i = 0;
        while (i < this.tableModel.getRowCount()) {
            KscfQueryColumn queryColumn = new KscfQueryColumn();
            queryColumn.queryId = this.queryId;
            queryColumn.columnName = (String)this.tableModel.getValueAt(i, 0);
            queryColumn.viewIndex = ((Number)this.tableModel.getValueAt(i, 1)).intValue();
            queryColumnList.add(queryColumn);
            ++i;
        }
        KscfQueryColumnStub.getInstance().putQueryColumn(queryColumnList);
        this.close();
    }

    @Override
    protected void cancelButtonAction() throws Exception {
        this.close();
    }

    @Override
    public void close() throws Exception {
        this.window.dispose();
    }

    public void showAsDialog(Component parentCompo) throws Exception {
        this.init();
        SwgDialog dialog = SwgUtil.createDialog(parentCompo);
        dialog.getContentPane().add((Component)this, "Center");
        dialog.setModal(true);
        dialog.setResizable(true);
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                try {
                    KswgQueryColumnListPanel.this.componentShownFirst(ev);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                    JOptionPane.showMessageDialog(null, ex.getMessage(), BcWords.getInstance().exception, 0);
                }
            }
        });
        dialog.setIconImage(AwtImageHelper.getWindowIconImage());
        this.window = dialog;
        SwgUtil.setCenter(this.window, 840.0, 680.0);
        this.window.setVisible(true);
    }
}

