/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf5.swg;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.ImageIcon;
import jp.co.extreme.awt.AwtImageHelper;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableContext;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.scf3.client.ScfSqlClientTask;
import jp.co.extreme.scf5.swg.IswgTableControlPanel2;
import jp.co.extreme.swing.SwgButton;
import jp.co.extreme.swing.SwgLabel;
import jp.co.extreme.swing.SwgTextField;
import jp.co.extreme.swing.SwgUtil;
import jp.co.extreme.task.Z_TskTaskScheduler;

public class IswgTableControlPanel3
extends IswgTableControlPanel2 {
    private static final long serialVersionUID = 658776206191835926L;
    private RmiRequest rmiReq;
    private ScfSqlClientTask sqlClientTask;
    protected SwgTextField rowCountField = new SwgTextField();
    protected SwgLabel elapsedTimeLabel = new SwgLabel();
    public SwgButton refreshButton;
    public SwgButton cancelButton;

    public IswgTableControlPanel3() throws Exception {
        this.rowCountField.setEditable(false);
        this.rowCountField.setHorizontalAlignment(4);
        this.rowCountField.setPreferredSize(SwgUtil.getTextFieldSize(this.getFont(), 14));
        this.addControl1(this.rowCountField);
        this.elapsedTimeLabel.setHorizontalAlignment(4);
        this.elapsedTimeLabel.setPreferredSize(SwgUtil.getTextFieldSize(this.getFont(), 8));
        this.addControl1(this.elapsedTimeLabel);
    }

    @Override
    public void started(ScfSqlClientTask sqlClientTask) throws Exception {
        super.started(sqlClientTask);
        this.sqlClientTask = sqlClientTask;
        this.cancelButton.setEnabled(true);
    }

    @Override
    public void tableColumnReceived(ScfSqlClientTask sqlClientTask, List<BcTableColumn> tableColumnList, int rowSize, BcTableContext tableContext) throws Exception {
        super.tableColumnReceived(sqlClientTask, tableColumnList, rowSize, tableContext);
        this.elapsedTimeLabel.setText(String.valueOf(BcNumberUtil.toString(tableContext.elapsedTime)) + "(ms)");
    }

    @Override
    public void loadedRowCountChanged(ScfSqlClientTask sqlClientTask, int rowSize, int loadedRowSize) throws Exception {
        super.loadedRowCountChanged(sqlClientTask, rowSize, loadedRowSize);
        if (rowSize >= 0) {
            this.rowCountField.setText(String.valueOf(BcNumberUtil.toString(loadedRowSize)) + "/" + BcNumberUtil.toString(rowSize));
        } else {
            this.rowCountField.setText(String.valueOf(BcNumberUtil.toString(loadedRowSize)) + " \u4ef6");
        }
    }

    @Override
    public void loaded(ScfSqlClientTask sqlClientTask, boolean eod) throws Exception {
        this.setControlEnabled2(eod);
        if (eod) {
            this.cancelButton.setEnabled(false);
        }
    }

    @Override
    public void errorOccurred(ScfSqlClientTask sqlClientTask, Throwable throwable) {
        super.errorOccurred(sqlClientTask, throwable);
        this.cancelButton.setEnabled(false);
    }

    @Override
    protected void actionPerformed2(ActionEvent ev) throws Exception {
        super.actionPerformed2(ev);
        if (ev.getSource() == this.refreshButton) {
            this.refreshButtonAction();
        } else if (ev.getSource() == this.cancelButton) {
            this.cancelButtonAction();
        }
    }

    @Override
    public void setControlEnabled2(boolean enabled) throws Exception {
        super.setControlEnabled2(enabled);
        if (this.refreshButton != null) {
            this.refreshButton.setEnabled(enabled);
        }
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(enabled);
        }
    }

    public void setRefreshButton() throws Exception {
        this.refreshButton = new SwgButton();
        this.refreshButton.addActionListener(this.actionListener);
        this.refreshButton.setIcon(new ImageIcon(AwtImageHelper.getImageAsIcon("refresh_64x64.png")));
        this.refreshButton.setPreferredSize(this.buttonSize);
        this.refreshButton.setToolTipText("\u6700\u65b0\u306e\u60c5\u5831\u306b\u66f4\u65b0\u3057\u307e\u3059\u3002");
        this.refreshButton.setEnabled(false);
        this.addControl2(this.refreshButton);
    }

    protected void refreshButtonAction() throws Exception {
        this.sqlClientTask.init();
        this.sqlClientTask.setRequest(this.rmiReq);
        Z_TskTaskScheduler.getInstance().startTask(this.sqlClientTask);
    }

    public void setCancelButton() throws Exception {
        this.cancelButton = new SwgButton();
        this.cancelButton.setIcon(new ImageIcon(AwtImageHelper.getImageAsIcon("sign_forbidden_64x64.png")));
        this.cancelButton.addActionListener(this.actionListener);
        this.cancelButton.setPreferredSize(this.buttonSize);
        this.cancelButton.setEnabled(false);
        this.addControl2(this.cancelButton);
    }

    protected void cancelButtonAction() throws Exception {
        this.sqlClientTask.cancel(this);
    }

    public void setOriginalRequest(RmiRequest rmiReq) {
        this.rmiReq = rmiReq;
    }

    public RmiRequest getOriginalRequest() throws Exception {
        return this.rmiReq;
    }
}

