/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf5.swg;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jp.co.extreme.awt.AwtImageHelper;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.util.BcInputValidator;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.html.common.HtmlBuilder;
import jp.co.extreme.print.DcfPrintCondition;
import jp.co.extreme.scf5.swg.IswgPrintConditionTableModel;
import jp.co.extreme.swing.SwgComboBox;
import jp.co.extreme.swing.SwgComponentUnit;
import jp.co.extreme.swing.SwgDecoratePanel;
import jp.co.extreme.swing.SwgDialog;
import jp.co.extreme.swing.SwgFormLayout;
import jp.co.extreme.swing.SwgLabel;
import jp.co.extreme.swing.SwgTableView;
import jp.co.extreme.swing.SwgUtil;

public class IswgPrintConditionPanel
extends SwgDecoratePanel {
    private static final long serialVersionUID = -7131223132589087730L;
    protected JPanel headerPanel = new JPanel();
    protected SwgComboBox printServiceComboBox = new SwgComboBox();
    protected SwgTableView tableView;
    protected JScrollPane tableScrollPane = new JScrollPane();
    protected DcfPrintCondition printCondition;
    protected String title;
    BcInputValidator inputValidator = BcInputValidator.getInstance();
    protected boolean completed;
    protected Window window;

    public IswgPrintConditionPanel() throws Exception {
        this.setOkButton(BcWords.getInstance().completion);
        this.setCancelButton(BcWords.getInstance().cancel);
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.centerPanel.setLayout(new BorderLayout());
        this.headerPanel.setPreferredSize(new Dimension(0, 40));
        this.centerPanel.add((Component)this.headerPanel, "North");
        SwgFormLayout formLayout = new SwgFormLayout();
        this.headerPanel.setLayout(formLayout);
        this.printServiceComboBox.setPreferredSize(new Dimension(380, 24));
        SwgComponentUnit controlUnit = new SwgComponentUnit((Component)new SwgLabel(BcWords.getInstance().printService, 4), this.printServiceComboBox);
        formLayout.componentUnitList.add(controlUnit);
        this.centerPanel.add((Component)this.tableScrollPane, "Center");
        HtmlBuilder htmlBuilder = new HtmlBuilder();
        String explanation = String.valueOf(htmlBuilder.html_start(true).toString()) + htmlBuilder.font_start(2) + htmlBuilder.font_start("2", "#000080", null) + "<b>" + "\u4e88\u5b9a\u756a\u53f7" + "</b>" + htmlBuilder.font_end() + "\u3067\u3059\u3002" + "<br>" + "-2\u65e2\u306b\u4ed6\u306e\u7aef\u672b\u304b\u3089\u3053\u306e\u756a\u53f7\u304c\u767b\u9332\u3055\u308c\u305f\u5834\u5408\u306f\u3001\u518d\u5ea6\u767b\u9332\u3092\u884c\u3063\u3066\u304f\u3060\u3055\u3044\u3002" + htmlBuilder.html_end();
    }

    public void setData(DcfPrintCondition printCondition, boolean printServiceEnabled, String title) throws Exception {
        this.printCondition = printCondition;
        this.title = title;
        this.printServiceComboBox.removeAllItems();
        int i = 0;
        while (i < printCondition.printServiceNameList.size()) {
            String printServiceName = printCondition.printServiceNameList.get(i);
            this.printServiceComboBox.addItem(printServiceName);
            ++i;
        }
        this.printServiceComboBox.setEnabled(printServiceEnabled);
        BcTableColumnModel tableColumnModel = IswgPrintConditionPanel.createTableColumnModel();
        IswgPrintConditionTableModel tableModel = new IswgPrintConditionTableModel(tableColumnModel);
        tableModel.printConditionElementList = printCondition.conditionElemetList;
        this.tableView = new SwgTableView(tableModel, tableColumnModel);
        this.tableScrollPane.getViewport().removeAll();
        this.tableScrollPane.getViewport().add(this.tableView);
    }

    public static BcTableColumnModel createTableColumnModel() throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = "\u5e33\u7968\u540d";
        mmdField.dataClass = String.class;
        mmdField.columnCount = 40;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = "<html><center>\u5de6\u4f59\u767d<br>(mm)</center></html>";
        mmdField.dataClass = Double.class;
        mmdField.decimalDigit = 0;
        mmdField.columnCount = 6;
        mmdField.decimalDigit = 1;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = true;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = "<html><center>\u4e0a\u4f59\u767d<br>(mm)</center></html>";
        mmdField.dataClass = Double.class;
        mmdField.decimalDigit = 0;
        mmdField.columnCount = 8;
        mmdField.decimalDigit = 1;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = true;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = "\u30c8\u30ec\u30a4";
        mmdField.dataClass = String.class;
        mmdField.columnCount = 10;
        mmdField.fieldDisplay.horizonalAlignment = 0;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = BcWords.getInstance().note;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 40;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        return tableColumnModel;
    }

    @Override
    protected void okButtonAction() throws Exception {
        super.okButtonAction();
        BcResult result = new BcResult();
        this.printCondition.printServiceName = BcStringUtil.toString(this.printServiceComboBox.getSelectedItem());
        if (this.printServiceComboBox.isEnabled()) {
            this.inputValidator.notNullable(BcWords.getInstance().printService, this.printCondition.printServiceName, result.getErrorList());
        }
        if (result.hasError()) {
            String message = BcMessageCreator.getInstance().createMessage(result.getErrorList()).toString();
            JOptionPane.showMessageDialog(this, message, BcWords.getInstance().warning, 2);
            return;
        }
        this.completed = true;
        this.close();
    }

    @Override
    protected void cancelButtonAction() throws Exception {
        super.cancelButtonAction();
        this.close();
    }

    @Override
    public void close() {
        this.window.dispose();
    }

    public boolean showAsDialog(Component ownerCompo) throws Exception {
        this.completed = false;
        SwgDialog dialog = SwgUtil.createDialog(ownerCompo);
        this.window = dialog;
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                try {
                    IswgPrintConditionPanel.this.cancelButtonAction();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
        dialog.setContentPane(this);
        dialog.setModal(true);
        dialog.setResizable(false);
        dialog.setIconImage(AwtImageHelper.getWindowIconImage());
        dialog.setTitle(this.title);
        SwgUtil.setCenter(this.window, 800.0, 400.0);
        this.window.setVisible(true);
        return this.completed;
    }
}

