/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xweb.common;

import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.base.util.BcReflectUtil;
import jp.co.extreme.datasource.util.DtsWordManagerImpl;
import jp.co.extreme.module.xweb.common.HtmlTableModel;
import jp.co.extreme.orm.entity.OrmPersistenceEntity;
import nlc.module.apcm.fx.Y_ApcmFxUtil3;

public class HtmlTableModelForEntity<T>
extends BcLoggableObject
implements HtmlTableModel {
    private Class<T> entityClass;
    private List<T> entityList;
    private List<AbstractMap.SimpleEntry<Field, MmdField>> mapEntryList;
    DtsWordManagerImpl wordManager = new DtsWordManagerImpl();

    public HtmlTableModelForEntity(T ... t) throws Exception {
        Class<?> classType = t.getClass().getComponentType();
        this.entityClass = classType;
        List<Field> fieldList = MmdUtil.createFieldListWithSuper(this.entityClass);
        OrmPersistenceEntity persistenceEntity = this.entityClass.getAnnotation(OrmPersistenceEntity.class);
        this.mapEntryList = new ArrayList<AbstractMap.SimpleEntry<Field, MmdField>>();
        int i = 0;
        while (i < fieldList.size()) {
            Field field = fieldList.get(i);
            MmdField mmdField = Y_ApcmFxUtil3.createMmd(field, persistenceEntity, this.wordManager);
            AbstractMap.SimpleEntry<Field, MmdField> mapEntry = new AbstractMap.SimpleEntry<Field, MmdField>(field, mmdField);
            this.mapEntryList.add(mapEntry);
            ++i;
        }
    }

    @Override
    public int getColumnCount() throws Exception {
        return this.mapEntryList.size();
    }

    @Override
    public int getRowCount() throws Exception {
        return this.entityList.size();
    }

    @Override
    public String getHeaderValue(int columnId) throws Exception {
        MmdField mmdField = this.getMmdField(columnId);
        return MmdUtil.getProvisionalHeaderValue(mmdField);
    }

    @Override
    public String getCellValue(int rowId, int columnId) throws Exception {
        T entity = this.entityList.get(rowId);
        AbstractMap.SimpleEntry<Field, MmdField> mapEntry = this.mapEntryList.get(columnId);
        Field field = mapEntry.getKey();
        Object value = BcReflectUtil.getFieldValue(field, entity);
        return BcStringUtil.toString(value);
    }

    public MmdField getMmdField(int columnId) throws Exception {
        AbstractMap.SimpleEntry<Field, MmdField> mapEntry = this.mapEntryList.get(columnId);
        return mapEntry.getValue();
    }

    public List<T> getEntityList() {
        return this.entityList;
    }

    public void setEntityList(List<T> entityList) {
        this.entityList = entityList;
    }
}

