/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsod.fx;

import java.util.ArrayList;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import jp.co.extreme.base.util.BcISO;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.international.FxxFlagImageHelper;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.module.xsod.common.XsodConstants;
import jp.co.extreme.module.xsod.common.XsodWords;
import jp.co.extreme.module.xsod.fx.XsodController;
import jp.co.extreme.module.xsod.fx.XsodUiFactory;
import jp.co.extreme.module.xsod.model.XsodOrderSession;

public class XsodCustomerTopPane
extends FxBorderPane {
    BorderPane borderPane = new BorderPane();
    Button topButton;
    List<Button> langButtonList;
    Button orderHistoryButton;
    Button billButton;
    Button callStaffButton;
    FxTextField debugField;
    HBox leftBox;
    HBox rightBox;

    public XsodCustomerTopPane() throws Exception {
        this.topButton = XsodUiFactory.getInstance().createButton(XsodWords.getInstance().\u30c8\u30c3\u30d7.toString());
        this.orderHistoryButton = XsodUiFactory.getInstance().createButton(XsodWords.getInstance().\u6ce8\u6587\u5c65\u6b74.toString());
        this.billButton = XsodUiFactory.getInstance().createButton(XsodWords.getInstance().\u304a\u4f1a\u8a08.toString());
        this.callStaffButton = XsodUiFactory.getInstance().createButton(XsodWords.getInstance().\u5e97\u54e1\u3092\u547c\u3076.toString());
        this.debugField = new FxTextField();
        this.leftBox = XsodUiFactory.getInstance().createHBox();
        this.rightBox = XsodUiFactory.getInstance().createHBox();
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.topButton.setOnAction(this.actionEventHandler);
        this.leftBox.getChildren().add((Object)this.topButton);
        this.langButtonList = new ArrayList<Button>();
        int i = 0;
        while (i < XsodConstants.langArray.length) {
            BcISO.ISO_639 iso639_1 = XsodConstants.langArray[i];
            Button button = new Button();
            button.setUserData((Object)iso639_1);
            Image image = FxxFlagImageHelper.getImageByLangCode(iso639_1.code);
            ImageView imageView = new ImageView(image);
            imageView.setImage(image);
            imageView.setFitWidth(XsodUiFactory.getInstance().langButtonWidth);
            imageView.setPreserveRatio(true);
            imageView.setSmooth(true);
            imageView.setCache(true);
            button.setGraphic((Node)imageView);
            button.setOnAction(this.actionEventHandler);
            this.langButtonList.add(button);
            this.leftBox.getChildren().add((Object)button);
            ++i;
        }
        this.borderPane.setLeft((Node)this.leftBox);
        this.rightBox.setPadding(XsodUiFactory.getInstance().insets1);
        this.rightBox.setSpacing(XsodUiFactory.getInstance().buttonSpacing1);
        this.billButton.setOnAction(this.actionEventHandler);
        this.rightBox.getChildren().add((Object)this.billButton);
        this.orderHistoryButton.setOnAction(this.actionEventHandler);
        this.rightBox.getChildren().add((Object)this.orderHistoryButton);
        this.callStaffButton.setOnAction(this.actionEventHandler);
        this.rightBox.getChildren().add((Object)this.callStaffButton);
        this.debugField.setEditable(false);
        this.rightBox.getChildren().add((Object)this.debugField);
        this.borderPane.setRight((Node)this.rightBox);
        StackPane baseParent = XsodUiFactory.getInstance().createBackgrondNode((Node)this.borderPane, Color.AQUA);
        this.setCenter((Node)baseParent);
        this.updateStaus();
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.topButton) {
            XsodController.getInstance().selectTop();
        } else if (ev.getSource() == this.orderHistoryButton) {
            XsodController.getInstance().orderHistory();
        } else if (ev.getSource() == this.billButton) {
            XsodController.getInstance().billRequest();
        } else if (ev.getSource() == this.callStaffButton) {
            XsodController.getInstance().callStaff();
        } else {
            int i = 0;
            while (i < this.langButtonList.size()) {
                Button button = this.langButtonList.get(i);
                if (ev.getSource() == button) {
                    BcISO.ISO_639 iso639_1 = (BcISO.ISO_639)((Object)button.getUserData());
                    XsodController.getInstance().setLangCode(iso639_1.code);
                }
                ++i;
            }
        }
    }

    public void updateStaus() throws Exception {
        XsodOrderSession orderSession = XsodController.getInstance().getOrderSession(false);
        if (orderSession == null) {
            this.orderHistoryButton.setDisable(true);
            this.billButton.setDisable(true);
            this.debugField.setText("NULL");
        } else {
            this.orderHistoryButton.setDisable(false);
            this.billButton.setDisable(false);
            this.debugField.setText(orderSession.tableNumber);
        }
    }
}

