/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsod.dao;

import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.xsod.model.XsodOrderSession;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class XsodOrderSessionDAO
extends OrmAbstractDAO<XsodOrderSession> {
    public static final int MODE_sessionId = 1;
    public static final int MODE_\uff57orking = 2;

    private XsodOrderSessionDAO() {
        super(new XsodOrderSession[0]);
        this.setTableName("xsod_order_session");
    }

    public static XsodOrderSessionDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectQuery createSelectQuery(SqlContext sqlContext, int mode, String alias, int sessionId, String tableNumber) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (sessionId > 0) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "id = " + sessionId);
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(tableNumber)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "table_number " + sqlContext.toCondition_string("=", tableNumber));
            selectQuery.addWhereElement(whereElement);
        }
        if (mode == 2) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("(" + aliasWk + "start_date_time Is Not Null AND " + aliasWk + "end_date_time Is Null)");
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        if (mode == 1) {
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "id");
        } else if (mode == 2) {
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "table_number");
        }
        return selectQuery;
    }

    public List<XsodOrderSession> getList(DtsSession dtsSession, int mode, int sessionId, String tableNumber) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "ods";
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, mode, alias, sessionId, tableNumber);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        String query = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, query);
    }

    public XsodOrderSession geById(DtsSession dtsSession, int sessionId) throws Exception {
        List<XsodOrderSession> entityList = this.getList(dtsSession, 2, sessionId, null);
        return BcCollectionUtil.getFirst(entityList);
    }

    public XsodOrderSession getWorkingByTableNumber(DtsSession dtsSession, String tableNumber) throws Exception {
        List<XsodOrderSession> entityList = this.getList(dtsSession, 2, -1, tableNumber);
        if (entityList.size() > 1) {
            String msg = "\u30c6\u30fc\u30d6\u30eb\u756a\u53f7'" + tableNumber + "'\u306e\u7a3c\u50cd\u4e2d\u304c2\u4ef6\u4ee5\u4e0a\u5b58\u5728\uff01";
            throw new Exception(msg);
        }
        return BcCollectionUtil.getFirst(entityList);
    }

    /* synthetic */ XsodOrderSessionDAO(XsodOrderSessionDAO xsodOrderSessionDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final XsodOrderSessionDAO instance = new XsodOrderSessionDAO(null);

        private SingletonHolder() {
        }
    }
}

