/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.wcb;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.scf4.table.ScfOnlineTableModel;

public class XdtsOnlineTableModel
extends ScfOnlineTableModel
implements AutoCloseable {
    private ResultSet rs;

    public ResultSet geResultSet() {
        return this.rs;
    }

    public void setResultSet(ResultSet rs) throws Exception {
        this.rs = rs;
        int rowCount = 0;
        if (rs.getType() == 1003) {
            BcLogUtil.info("setResultSet:TYPE_FORWARD_ONLY");
            ArrayList<List> rowList = new ArrayList<List>();
            while (rs.next()) {
                if (++rowCount % 1000 == 0) {
                    BcLogUtil.info("rowCount=" + BcNumberUtil.toString(rowCount));
                }
                List row = this.loadRow(rs);
                rowList.add(row);
            }
            this.addRowList(rowList);
        } else {
            if (rs.last()) {
                rowCount = rs.getRow();
            }
            this.setRowCount(rowCount);
        }
    }

    @Override
    protected List loadRow(int rowId) {
        try {
            if (this.rs.getType() != 1003) {
                this.rs.absolute(rowId + 1);
                List row = this.loadRow(this.rs);
                return row;
            }
            BcLogUtil.error("loadRow:rs.getType()=TYPE_FORWARD_ONLY");
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        return null;
    }

    protected List loadRow(ResultSet rs) throws Exception {
        ArrayList<Object> row = new ArrayList<Object>();
        int i = 0;
        while (i < rs.getMetaData().getColumnCount()) {
            int columnIndex = i + 1;
            Object value = rs.getObject(columnIndex);
            row.add(value);
            ++i;
        }
        return row;
    }

    @Override
    public void close() throws Exception {
        BcLogUtil.debug("XdtsOnlineTableModel#close:rs=" + this.rs);
        if (this.rs != null && !this.rs.isClosed()) {
            this.rs.close();
            this.rs = null;
        }
    }
}

