/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcRegexUtil;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.tree.FxTreeFolder;
import jp.co.extreme.fx.tree.FxTreeItem;
import jp.co.extreme.fx.tree.FxTreeItemHelperImpl;
import jp.co.extreme.fx.tree.FxTreeUtil;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.module.xdts.fx.InnerComparator1;
import jp.co.extreme.module.xdts.model.XdtsSchemaObject;
import jp.co.extreme.module.xdts.model.v001.XdtsExtractionCondition;
import jp.co.extreme.module.xdts.stub.XdtsExtractionConditionStub;

public final class XdtsObjectTreeUtil
extends FxBorderPane {
    static InnerComparator1 comparator1 = new InnerComparator1();

    private XdtsObjectTreeUtil() {
    }

    public static void setPath1(FxTreeItem treeItem, FxTreeItem parentTreeItem1, String groupPath, FxTreeItemHelperImpl treeItemHelper, Comparator comparator2) throws Exception {
        FxTreeItem parentTreeItem = parentTreeItem1;
        if (!BcStringUtil.isEmpty(groupPath)) {
            String[] elemnts = BcStringUtil.split(groupPath, BcRegexUtil.escapEncode(BcStringUtil.SLASH_STR));
            int j = 0;
            while (j < elemnts.length) {
                String group2 = elemnts[j];
                List findTreeItemList = FxTreeUtil.findByValue((List<? extends TreeItem>)parentTreeItem.getChildren(), Arrays.asList(group2), comparator1);
                if (findTreeItemList.size() <= 0) {
                    FxTreeItem tmpTreeItem = treeItemHelper.creaeTreeItem();
                    FxTreeFolder treeFolder = new FxTreeFolder(group2, groupPath);
                    tmpTreeItem.setValue(treeFolder);
                    tmpTreeItem.setGraphic((Node)FxImageHelper.createImageView_icon("folder_closed_64x64.png"));
                    parentTreeItem.getChildren().add((Object)tmpTreeItem);
                    parentTreeItem.getChildren().sort((Comparator)comparator1);
                    parentTreeItem = tmpTreeItem;
                } else {
                    parentTreeItem = (FxTreeItem)BcCollectionUtil.getFirst(findTreeItemList);
                }
                ++j;
            }
        }
        parentTreeItem.getChildren().add((Object)treeItem);
        Collections.sort(parentTreeItem.getChildren(), comparator2);
    }

    public static String getGroupPath(FxTreeItem treeItem) throws Exception {
        String groupPath = null;
        if (treeItem.getValue() instanceof FxTreeFolder) {
            FxTreeFolder treeFolder = (FxTreeFolder)treeItem.getValue();
            if (treeFolder.userObject instanceof String) {
                groupPath = (String)treeFolder.userObject;
            }
        }
        return groupPath;
    }

    public static XdtsExtractionCondition createExtractionCondition(long dataSourceId, XdtsSchemaObject schemaObject, Node baseNode) throws Exception {
        BcResult result = XdtsExtractionConditionStub.getInstance().createByTable(dataSourceId, schemaObject.name1);
        if (result.hasError()) {
            String msg = BcMessageCreator.getInstance().createMessage(result.getErrorList());
            FxOptionPane.showMessageDialog(baseNode, (Object)msg, BcWords.getInstance().error, 0);
            return null;
        }
        XdtsExtractionCondition extractionCondition = (XdtsExtractionCondition)result.getUserObject();
        return extractionCondition;
    }
}

