/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.wcb;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.util.BcPeriod;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.httpserver.HtsvArgument;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.module.wbs1.dao.Wbs1AttendanceDAO;
import jp.co.extreme.module.wbs1.model.Wbs1Attendance;
import jp.co.extreme.module.wbs1.model.Wbs1Workspace;
import jp.co.extreme.module.wbs1.server.PersonManager;
import jp.co.extreme.module.wbs1.server.WorkspaceManager;
import jp.co.extreme.module.wbs1.wcb.Wbs1AttendanceFormWCB;
import jp.co.extreme.module.xsys.common.XsysWords;
import jp.co.extreme.module.xweb.common.CalendarTableCreatorNavi;
import jp.co.extreme.module.xweb.common.WbxConstants;
import jp.co.extreme.module.xweb.common.XwebHtmlBuilder;
import jp.co.extreme.module.xweb.common.XwebUtil;

public abstract class AttendanceCalendarCreator
extends CalendarTableCreatorNavi {
    HtsvArgument wcbArg;
    int year;
    int month;
    long personId;
    long workspaceId;
    Map<Integer, List<Wbs1Attendance>> attendanceMap;

    public StringBuilder create(HtsvArgument wcbArg, DtsSession dtsSession, int year, int month, long personId, long workspaceId) throws Exception {
        this.wcbArg = wcbArg;
        this.year = year;
        this.month = month;
        this.personId = personId;
        this.workspaceId = workspaceId;
        Wbs1Workspace workspace = WorkspaceManager.getInstance().getWorkspace(wcbArg.getSiteContext(), workspaceId);
        BcPeriod calendarPeriod = BcTimeUtil.toCalendarPeriod(year, month, 1);
        int calendarStart = BcTimeUtil.toYyyyMMdd(calendarPeriod.start);
        int calendarEnd = BcTimeUtil.toYyyyMMdd(calendarPeriod.end);
        List<Wbs1Attendance> attendanceList1 = null;
        attendanceList1 = personId > 0L ? Wbs1AttendanceDAO.getInstance().getListByPersonId(dtsSession, personId, workspaceId, calendarStart, calendarEnd) : Wbs1AttendanceDAO.getInstance().getListByPeriod(dtsSession, workspaceId, calendarStart, calendarEnd);
        this.getLogger().debug("attendanceList1.size()=" + attendanceList1.size());
        this.attendanceMap = new HashMap<Integer, List<Wbs1Attendance>>();
        for (Wbs1Attendance attendance : attendanceList1) {
            List<Wbs1Attendance> attendanceList2 = this.attendanceMap.get(attendance.startDate);
            if (attendanceList2 == null) {
                attendanceList2 = new ArrayList<Wbs1Attendance>();
                this.attendanceMap.put(attendance.startDate, attendanceList2);
            }
            attendanceList2.add(attendance);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(XsysWords.getInstance().\u52e4\u52d9\u5148);
        sb.append(":");
        if (!BcStringUtil.isEmpty(workspace.name)) {
            sb.append(workspace.name);
        }
        Calendar currentMonth = BcTimeUtil.toCalendarMonthId(year, month - 1, 1);
        sb.append((CharSequence)super.create(year, month));
        return sb;
    }

    @Override
    protected String createDateNoteCellValue(Calendar calendar) throws Exception {
        if (this.personId > 0L) {
            return this.createDateCellValue4Person(calendar);
        }
        return this.createDateCellValue4Management(calendar);
    }

    protected String createDateCellValue4Person(Calendar calendar) throws Exception {
        StringBuilder sb = new StringBuilder();
        int yyyyMMdd = BcTimeUtil.toYyyyMMdd(calendar);
        List<Wbs1Attendance> attendanceList = this.attendanceMap.get(yyyyMMdd);
        if (attendanceList != null) {
            for (Wbs1Attendance attendance : attendanceList) {
                if (!BcStringUtil.isEmpty(sb)) {
                    sb.append(this.htmlBuilder.br());
                }
                StringBuilder sb2 = new StringBuilder();
                sb2.append(this.toPeriodStr(attendance));
                String param1 = WbfwUtil.createParameter((Enum)WbxConstants.QueryParam.attendanceId, Long.toString(attendance.id));
                String href = String.valueOf(XwebUtil.toRelativePath(this.wcbArg.getRequest(), Wbs1AttendanceFormWCB.Method.form)) + WbfwUtil.createUrlQuery(param1);
                String link = XwebHtmlBuilder.getInstance().link_underLine(href, sb2.toString(), null);
                sb.append(link);
            }
        } else if (XwebUtil.isAcceptDate(calendar)) {
            String urlQuery = this.createUrlQuery(yyyyMMdd);
            String href = String.valueOf(Wbs1AttendanceFormWCB.Method.form.getPath()) + urlQuery;
            String link = XwebHtmlBuilder.getInstance().link_underLine(href, XsysWords.getInstance().\u672a\u5b9a, null);
            sb.append(link);
        }
        return sb.toString();
    }

    protected String createDateCellValue4Management(Calendar calendar) throws Exception {
        StringBuilder sb = new StringBuilder();
        int yyyyMMdd = BcTimeUtil.toYyyyMMdd(calendar);
        List<Wbs1Attendance> attendanceList = this.attendanceMap.get(yyyyMMdd);
        if (attendanceList != null) {
            for (Wbs1Attendance attendance : attendanceList) {
                if (!BcStringUtil.isEmpty(sb)) {
                    sb.append(this.htmlBuilder.br());
                }
                StringBuilder sb2 = new StringBuilder();
                sb2.append(this.toPeriodStr(attendance));
                PersonManager personManager = PersonManager.getInstance(this.wcbArg.getSiteContext().getDataSourceName());
                String personName = personManager.getName(attendance.personId);
                sb2.append(" " + personName);
                String param1 = WbfwUtil.createParameter((Enum)WbxConstants.QueryParam.attendanceId, Long.toString(attendance.id));
                String href = String.valueOf(XwebUtil.toRelativePath(this.wcbArg.getRequest(), Wbs1AttendanceFormWCB.Method.form)) + WbfwUtil.createUrlQuery(param1);
                String link = XwebHtmlBuilder.getInstance().link_underLine(href, sb2.toString(), null);
                sb.append(link);
            }
        } else {
            String urlQuery = this.createUrlQuery(yyyyMMdd);
            String url = String.valueOf(Wbs1AttendanceFormWCB.Method.form.getPath()) + urlQuery;
            String link = XwebHtmlBuilder.getInstance().link_underLine(url, XsysWords.getInstance().\u672a\u5b9a, null);
            sb.append(link);
        }
        return sb.toString();
    }

    protected String createUrlQuery(int yyyyMMdd) throws Exception {
        String param1 = WbfwUtil.createParameter((Enum)WbxConstants.QueryParam.personId, Long.toString(this.personId));
        String param2 = WbfwUtil.createParameter((Enum)WbxConstants.QueryParam.workspaceId, Long.toString(this.workspaceId));
        String param3 = WbfwUtil.createParameter((Enum)WbxConstants.QueryParam.date, Integer.toString(yyyyMMdd));
        return WbfwUtil.createUrlQuery(param1, param2, param3);
    }

    protected String toPeriodStr(Wbs1Attendance attendance) throws Exception {
        StringBuilder sb2 = new StringBuilder();
        sb2.append(BcTimeUtil.toStringFromHHmm(attendance.startTime, "HH:mm"));
        sb2.append("-");
        sb2.append(BcTimeUtil.toStringFromHHmm(attendance.endTime, "HH:mm"));
        return sb2.toString();
    }
}

