/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.dao;

import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.wbs1.model.Wbs1Customer;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class Wbs1CustomerDAO
extends OrmAbstractDAO<Wbs1Customer> {
    public static final int MODE_ownerId = 1;

    private Wbs1CustomerDAO() {
        super(new Wbs1Customer[0]);
        this.setTableName("wbs1_customer");
    }

    public static Wbs1CustomerDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectQuery createSelectQuery(SqlContext sqlContext, int mode, String alias, long ownerId, String emailAddress) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (ownerId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "owner_id =" + ownerId);
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(emailAddress)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "email_address" + sqlContext.toCondition_string("=", emailAddress));
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        if (mode == 1) {
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "owner_id");
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "email_address");
        }
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        return selectQuery;
    }

    public <T> List<T> getList(DtsSession dtsSession, int mode, long ownerId, String emailAddress) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "a";
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, mode, alias, ownerId, emailAddress);
        String query = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, query);
    }

    public <T> T getByEmailAddress(DtsSession dtsSession, long ownerId, String emailAddress) throws Exception {
        if (BcStringUtil.isEmpty(emailAddress)) {
            return null;
        }
        List<T> entityList = this.getList(dtsSession, 1, ownerId, emailAddress);
        return BcCollectionUtil.getFirst(entityList);
    }

    /* synthetic */ Wbs1CustomerDAO(Wbs1CustomerDAO wbs1CustomerDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final Wbs1CustomerDAO instance = new Wbs1CustomerDAO(null);

        private SingletonHolder() {
        }
    }
}

