/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbfw.wcbx;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.util.BcConditionElement;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.etc.sql.ScfMmdServerUtil;
import jp.co.extreme.html.util.HtmlUtil;
import jp.co.extreme.httpserver.HtsvArgument;
import jp.co.extreme.httpserver.HtsvRequestParameter;
import jp.co.extreme.httpserver.HtsvResourceHolder;
import jp.co.extreme.httpserver.WbfwCmcManager;
import jp.co.extreme.module.wbfw.html.WbfwHtmlTableCreator;
import jp.co.extreme.module.wbfw.html.WbfwHttpTableHandleResource;
import jp.co.extreme.module.wbfw.wcb.WbfwAbstractWCB;
import jp.co.extreme.rmi.common.RmiMethodContext;
import jp.co.extreme.scf.common.ScfHandle;
import jp.co.extreme.scf.common.ScfHandleImpl;
import jp.co.extreme.scf.server.ScfServerContainer;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.context.SqlContext;

public class WbfwDatabaseTableListWCB
extends WbfwAbstractWCB {
    public static String getInvokeMethodCode(HtsvArgument wcbArg) throws Exception {
        WbfwCmcManager cmcManager = HtsvResourceHolder.getInstance().cmcManager;
        RmiMethodContext methodContext = cmcManager.getMethodContextByName(wcbArg, String.valueOf(WbfwDatabaseTableListWCB.class.getName()) + ".primaryMethod", "dbTableList");
        return methodContext.id;
    }

    public void executeQuery(HtsvArgument wcbArg) throws Exception {
        HtsvRequestParameter requestParameter = wcbArg.getRequestParameter();
        DtsSession dtsSession = wcbArg.getDtsSession(this);
        SqlContext sqlContext = dtsSession.getSqlContext();
        String tableType = requestParameter.getAsString("tableType");
        String[] tableTypes = null;
        tableTypes = !BcStringUtil.isEmpty(tableType) ? new String[]{tableType} : new String[]{"TABLE", "VIEW"};
        try {
            SqlStatement stmt = dtsSession.getConnection().createStatement();
            try {
                ResultSet tmpRs = dtsSession.getConnection().getMetaData().getTables(null, null, null, tableTypes);
                SqlResultSet rs = new SqlResultSet(tmpRs, stmt);
                ArrayList<BcConditionElement> conditionList = new ArrayList<BcConditionElement>();
                List<String> tableColumnNameList = null;
                List<BcTableColumn> tableColumnList = ScfMmdServerUtil.createTableColumnList(dtsSession, rs.getMetaData(), Locale.getDefault(), tableColumnNameList);
                WbfwHttpTableHandleResource httpTableHandleResource = new WbfwHttpTableHandleResource();
                httpTableHandleResource.setDBResource(dtsSession, rs, tableColumnList);
                httpTableHandleResource.setConditionList(conditionList);
                ScfHandleImpl handle = new ScfHandleImpl();
                handle.addHandleResource(httpTableHandleResource);
                ScfServerContainer.getInstance().getHandleManager().addHandle(handle);
            }
            catch (Exception ex) {
                stmt.close();
                throw ex;
            }
        }
        catch (Exception ex) {
            dtsSession.desturuct();
            throw ex;
        }
    }

    public StringBuilder createHtmlL3(HtsvArgument wcbArg) throws Exception {
        HtsvRequestParameter requestParameter = wcbArg.getRequestParameter();
        String tableHandleId = requestParameter.getAsString("tableHandleId");
        ScfHandle handle = ScfServerContainer.getInstance().getHandleManager().getHandle(tableHandleId);
        WbfwHttpTableHandleResource httpTableHandleResource = (WbfwHttpTableHandleResource)handle.getHandleResource(0);
        int pageSeq = BcNumberUtil.parseInt(requestParameter.getAsString("tablePageNo"), 0);
        Object sessionAttribute = null;
        StringBuilder sb = new StringBuilder(2048);
        sb.append("\n");
        sb.append(this.getHtmlBuilder().form_start("form1", wcbArg.getSiteContext().getUrlBase(wcbArg.getRequest()), "POST", null));
        String cmc = WbfwDatabaseTableListWCB.getInvokeMethodCode(wcbArg);
        sb.append(this.getHtmlBuilder().table_start(null, null, null, 0, 0, 0, null));
        sb.append(this.getHtmlBuilder().tr_start());
        sb.append(this.getHtmlBuilder().tableCell(1, 1, 2, 0, null, "14", null));
        sb.append(this.getHtmlBuilder().td_end());
        sb.append(this.getHtmlBuilder().tr_end());
        sb.append(this.getHtmlBuilder().tr_start());
        sb.append(this.getHtmlBuilder().tableCell(1, 1, 0, 0, null, "0", null));
        sb.append(this.getHtmlBuilder().td_end());
        sb.append(this.getHtmlBuilder().tr_end());
        sb.append(this.getHtmlBuilder().tr_start());
        sb.append(this.getHtmlBuilder().tableCell(1, 1, 2, 0, null, "14", null));
        sb.append(this.getHtmlBuilder().td_end());
        sb.append(this.getHtmlBuilder().tr_end());
        sb.append(this.getHtmlBuilder().tr_start());
        sb.append(this.getHtmlBuilder().tableCell(1, 1, 2, 1, null, null, null));
        HtmlTableCreator htmlTableCreator = new HtmlTableCreator();
        sb.append((CharSequence)htmlTableCreator.createTable(wcbArg, handle));
        sb.append(this.getHtmlBuilder().td_end());
        sb.append(this.getHtmlBuilder().tr_end());
        sb.append(this.getHtmlBuilder().table_end());
        sb.append(this.getHtmlBuilder().form_end());
        return sb;
    }

    protected class HtmlTableCreator
    extends WbfwHtmlTableCreator {
        String dataId = null;

        protected HtmlTableCreator() {
        }

        @Override
        public StringBuilder createCell(HtsvArgument wcbArg, MmdField mmdField, BcTableColumn tableColumn, Object value, int rowIndex) throws Exception {
            if (BcStringUtil.equalsIgnoreCase(mmdField.tableColumnName, ".TABLE_NAME")) {
                String url = String.valueOf(wcbArg.getRequest().getRequestURI()) + "?" + "sid" + "=" + wcbArg.getRequest().getRequestedSessionId() + "&" + "tableName" + "=" + value.toString() + "&" + "cmc" + "=" + "dbColumnList";
                value = HtmlUtil.link(url, null, null, value.toString());
                return super.createCell(wcbArg, mmdField, tableColumn, value, rowIndex);
            }
            return super.createCell(wcbArg, mmdField, tableColumn, value, rowIndex);
        }
    }
}

