/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.htsv.dao;

import java.util.HashMap;
import java.util.Map;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class HtsvSitePropertyDAO
extends OrmAbstractDAO {
    public static final int MODE_default = 1;

    private HtsvSitePropertyDAO() {
        super(new Object[0]);
        this.setTableName("htsv_site_property");
    }

    public static HtsvSitePropertyDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectQuery createSelectQuery(SqlContext sqlContext, int mode, String alias, int siteId) throws Exception {
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        selectQuery.addSelectColumn(String.valueOf(aliasWk) + "id");
        selectQuery.addSelectColumn(String.valueOf(aliasWk) + "key_");
        selectQuery.addSelectColumn(String.valueOf(aliasWk) + "value_");
        if (siteId > 0) {
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "id =" + siteId);
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        if (mode == 1) {
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "id");
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "key_");
        }
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        return selectQuery;
    }

    public Map<String, String> getMap(DtsSession dtsSession, int siteId) throws Exception {
        if (siteId <= 0) {
            throw new Exception("siteId=" + siteId);
        }
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "a";
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, 1, alias, siteId);
        String sql = sqlContext.buildSelectQuery(selectQuery);
        HashMap<String, String> map = new HashMap<String, String>();
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String key = rs.getString(2);
                String value = rs.getString(3);
                map.put(key, value);
            }
            rs.close();
        }
        return map;
    }

    public int deleteBySiteId(DtsSession dtsSession, int siteId) throws Exception {
        String query = "DELETE FROM " + this.getTableName() + " WHERE id = " + siteId;
        return SqlUtil.executeUpdate(dtsSession.getConnection(), query);
    }

    public int putProperty(DtsSession dtsSession, int siteId, String key, String value) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = "UPDATE " + this.getTableName() + " SET value_ = " + sqlContext.toSet(value) + " WHERE id = " + siteId + " AND key_ = " + sqlContext.toSet(key);
        int recCnt = SqlUtil.executeUpdate(dtsSession.getConnection(), query);
        if (recCnt > 0) {
            return recCnt;
        }
        query = "INSERT INTO " + this.getTableName() + " (id, key_, value_)" + " VALUES (" + siteId + "," + sqlContext.toSet(key) + "," + sqlContext.toSet(value) + ")";
        recCnt = SqlUtil.executeUpdate(dtsSession.getConnection(), query);
        return recCnt;
    }

    /* synthetic */ HtsvSitePropertyDAO(HtsvSitePropertyDAO htsvSitePropertyDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final HtsvSitePropertyDAO instance = new HtsvSitePropertyDAO(null);

        private SingletonHolder() {
        }
    }
}

