/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.lib.html.mdl;

import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcStreamUtil;
import jp.co.extreme.css.common.CssBuiler;
import jp.co.extreme.html.common.HtmlBuilder;
import jp.co.extreme.html.common.HtmlConstants;
import jp.co.extreme.html.common.HtmlGlobalAttribute;
import jp.co.extreme.html.util.HtmlUtil;
import jp.co.extreme.lib.html.mdc.MdcConstants;
import jp.co.extreme.lib.html.mdl.MdlConstants;
import jp.co.extreme.module.xweb.common.XwebCssUtil;
import jp.co.extreme.module.xweb.common.XwebIconManager;

public final class MdlCreator {
    public static final String portfolio_max_width = "portfolio-max-width";
    public static final int column12 = 12;
    public static final int column8 = 8;
    public static final int column6 = 6;
    public static final int column4 = 4;
    public static final String is_active = "is-active";
    public static final int shadowSizeDefault = 2;
    public static final String small = "<small>";
    public static final String small_end = "</small>";
    public static final String article_image = "article-image";
    HtmlBuilder htmlBuilder = HtmlBuilder.getInstance();
    String dialogScript = null;

    public static MdlCreator getInstance() {
        return SingletonHolder.instance;
    }

    public HtmlBuilder getHtmlBuilder() {
        return this.htmlBuilder;
    }

    public StringBuilder cellCol(int columnSize) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)MdlConstants.MdlClass.mdl_cell);
        sb.append("--");
        sb.append(columnSize);
        sb.append("-col");
        return sb;
    }

    public StringBuilder cellTablet(int columnSize) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.cellCol(columnSize));
        sb.append("-tablet");
        return sb;
    }

    public StringBuilder cellPhone(int columnSize) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.cellCol(columnSize));
        sb.append("-phone");
        return sb;
    }

    public StringBuilder shadow(int shadowSize) throws Exception {
        if (shadowSize < 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append((Object)MdlConstants.MdlClass.mdl_shadow);
        sb.append("--");
        sb.append(shadowSize);
        sb.append("dp");
        return sb;
    }

    public String div_grid_portfolio_start() throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = BcStringUtil.toSsv(new Object[]{MdlConstants.MdlClass.mdl_grid, portfolio_max_width});
        return this.getHtmlBuilder().div_start(globalAttribute, true);
    }

    public StringBuilder grid_portfolio(CharSequence content) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.div_grid_portfolio_start());
        BcStringUtil.append(sb, content);
        sb.append(this.getHtmlBuilder().div_end());
        return sb;
    }

    public StringBuilder div_grid_cell_start(int columnSize, int shadowSize) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        int columnSizeTablet = columnSize;
        int columnSizePhone = columnSizeTablet * 2;
        if (columnSizePhone > 12) {
            columnSizePhone = 12;
        }
        globalAttribute.clazz = BcStringUtil.toSsv(new Object[]{MdlConstants.MdlClass.mdl_cell, this.cellCol(columnSize), this.cellTablet(columnSizeTablet), this.cellPhone(columnSizePhone), this.shadow(shadowSize)});
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlBuilder().div_start(globalAttribute));
        sb.append(this.getHtmlBuilder().appLineSep());
        return sb;
    }

    public StringBuilder div_grid_cell_start(int columnSize) throws Exception {
        return this.div_grid_cell_start(columnSize, -1);
    }

    public StringBuilder grid_cell(int columnSize, CharSequence content) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.div_grid_cell_start(columnSize));
        BcStringUtil.append(sb, content);
        sb.append(this.getHtmlBuilder().div_end());
        return sb;
    }

    public StringBuilder div_grid_cell_shadow_start(int columnSize) throws Exception {
        return this.div_grid_cell_start(columnSize, 2);
    }

    public StringBuilder grid_cell_shadow(int columnSize, CharSequence content) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.div_grid_cell_shadow_start(columnSize));
        BcStringUtil.append(sb, content);
        sb.append(this.getHtmlBuilder().div_end());
        return sb;
    }

    public StringBuilder card_media(CharSequence content) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlBuilder().div_start(MdlConstants.MdlClass.mdl_card__media.toString()));
        BcStringUtil.append(sb, content);
        sb.append(this.getHtmlBuilder().div_end());
        return sb;
    }

    public String div_card_start(String width, String height, int shadowSize, String padding) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = BcStringUtil.toSsv(new Object[]{MdlConstants.MdlClass.mdl_card, this.shadow(shadowSize)});
        CssBuiler cssBuiler = new CssBuiler();
        if (!BcStringUtil.isEmpty(width)) {
            cssBuiler.width(width);
        }
        if (!BcStringUtil.isEmpty(height)) {
            cssBuiler.height(height);
        }
        if (!BcStringUtil.isEmpty(padding)) {
            cssBuiler.padding(padding);
        }
        cssBuiler.margin_left("auto");
        cssBuiler.margin_right("auto");
        globalAttribute.style = cssBuiler.build();
        return this.getHtmlBuilder().div_start(globalAttribute, true);
    }

    public StringBuilder div_card(CharSequence content, String width, String height, int shadowSize) throws Exception {
        StringBuilder sb = new StringBuilder();
        String padding = null;
        sb.append(this.div_card_start(width, height, shadowSize, padding));
        BcStringUtil.append(sb, content);
        sb.append(this.getHtmlBuilder().div_end());
        return sb;
    }

    public StringBuilder div_card(CharSequence content, String width, String height) throws Exception {
        int shadowSize = -1;
        return this.div_card(content, width, height, shadowSize);
    }

    public StringBuilder div_card(CharSequence content, String width) throws Exception {
        String height = null;
        return this.div_card(content, width, height);
    }

    public StringBuilder div_card(CharSequence content) throws Exception {
        String width = null;
        String height = null;
        return this.div_card(content, width, height);
    }

    public StringBuilder div_card_shadow(CharSequence content, String width) throws Exception {
        String height = null;
        return this.div_card(content, width, height, 2);
    }

    public String div_card_start(String width) throws Exception {
        String height = null;
        int shadowSize = 2;
        String padding = "8px";
        return this.div_card_start(width, height, shadowSize, padding);
    }

    public StringBuilder card_title(CharSequence title, String bgColorCode) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = BcStringUtil.toSsv(new Object[]{MdlConstants.MdlClass.mdl_card__title});
        if (!BcStringUtil.isEmpty(bgColorCode)) {
            globalAttribute.style = XwebCssUtil.background_color(bgColorCode);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlBuilder().div_start(globalAttribute, false));
        BcStringUtil.append(sb, title);
        sb.append(this.getHtmlBuilder().div_end());
        return sb;
    }

    public StringBuilder card_title(CharSequence title) throws Exception {
        return this.card_title(title, null);
    }

    public StringBuilder card_title_icon(CharSequence title, MdcConstants.MdcIcon mdcIcon) throws Exception {
        return this.card_title(title, null);
    }

    public String div_card_supporting_text_start() throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = BcStringUtil.toSsv(new Object[]{MdlConstants.MdlClass.mdl_card__supporting_text});
        return this.getHtmlBuilder().div_start(globalAttribute, true);
    }

    public String card_supporting_text(String text, String colorCode, String id) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.div_card_supporting_text_start());
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.id = id;
        CssBuiler cssBuiler = new CssBuiler();
        if (!BcStringUtil.isEmpty(colorCode)) {
            globalAttribute.style = cssBuiler.color(colorCode).build();
        }
        sb.append((CharSequence)this.getHtmlBuilder().span_start(globalAttribute));
        BcStringUtil.append(sb, text);
        sb.append(this.getHtmlBuilder().span_end());
        sb.append(this.getHtmlBuilder().div_end());
        return sb.toString();
    }

    public String card_supporting_text(String text) throws Exception {
        return this.card_supporting_text(text, null, null);
    }

    public StringBuilder card_actions(String actions2, boolean isBorder) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = BcStringUtil.toSsv(new Object[]{MdlConstants.MdlClass.mdl_card__actions});
        if (isBorder) {
            globalAttribute.clazz = this.getHtmlBuilder().appendClass(globalAttribute.clazz, MdlConstants.MdlClass.mdl_card__border.toString());
        }
        StringBuilder sb = new StringBuilder(this.getHtmlBuilder().div_start(globalAttribute, false));
        BcStringUtil.append(sb, actions2);
        sb.append(this.getHtmlBuilder().div_end());
        return sb;
    }

    public StringBuilder card_actions(String actions2) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = BcStringUtil.toSsv(new Object[]{MdlConstants.MdlClass.mdl_card__actions});
        StringBuilder sb = new StringBuilder(this.getHtmlBuilder().div_start(globalAttribute, false));
        BcStringUtil.append(sb, actions2);
        sb.append(this.getHtmlBuilder().div_end());
        return sb;
    }

    public StringBuilder cell_shadow(String title, String content, int margin) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.div_grid_cell_shadow_start(12));
        if (!BcStringUtil.isEmpty(title)) {
            sb.append((CharSequence)this.card_title(title));
        }
        if (margin > 0) {
            sb.append((CharSequence)this.getHtmlBuilder().div(content, null, margin));
        } else {
            BcStringUtil.append(sb, content);
        }
        sb.append(this.getHtmlBuilder().div_end());
        return sb;
    }

    public StringBuilder cell_shadow_margin(String title, String content) throws Exception {
        return this.cell_shadow(title, content, 8);
    }

    public StringBuilder linkButton(String href, String value) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = BcStringUtil.toSsv(new Object[]{MdlConstants.MdlClass.mdl_button, MdlConstants.MdlClass.mdl_button__colored, MdlConstants.MdlClass.mdl_js_button, MdlConstants.MdlClass.mdl_js_ripple_effect, MdlConstants.MdlClass.mdl_button__accent});
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlBuilder().a(globalAttribute, href, value, null));
        return sb;
    }

    public StringBuilder navigationLink(String href, boolean is_active, String text, String iconTag) throws Exception {
        String classValues = null;
        classValues = is_active ? BcStringUtil.toSsv(new Object[]{MdlConstants.MdlClass.mdl_navigation__link, is_active}) : BcStringUtil.toSsv(new Object[]{MdlConstants.MdlClass.mdl_navigation__link});
        StringBuilder sb = new StringBuilder();
        String target = null;
        sb.append(this.getHtmlBuilder().a_start(href, classValues, target));
        if (BcStringUtil.isEmpty(iconTag)) {
            iconTag = XwebIconManager.createTag(XwebIconManager.WebIcon.dummy);
        } else {
            sb.append(iconTag);
        }
        sb.append(HtmlConstants.HtmlSpecialCharacter.space.value);
        if (!BcStringUtil.isEmpty(text)) {
            sb.append(text);
        }
        sb.append(this.getHtmlBuilder().a_end());
        sb.append(this.getHtmlBuilder().appLineSep());
        return sb;
    }

    public StringBuilder textArea(String inputName, int columnCount, int rowCount, String label, String value, boolean disabled, boolean readonly, boolean characterCounterEnabled, String script) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = BcStringUtil.toSsv(new Object[]{MdlConstants.MdlClass.mdl_textfield, MdlConstants.MdlClass.mdl_js_textfield, MdlConstants.MdlClass.mdl_textfield__floating_label});
        globalAttribute.style = "display: block;";
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlBuilder().div_start(globalAttribute, true));
        globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = BcStringUtil.toSsv(new Object[]{MdlConstants.MdlClass.mdl_textfield__input});
        globalAttribute.id = inputName;
        String textArea = this.getHtmlBuilder().textArea(globalAttribute, inputName, value, columnCount, rowCount, disabled, readonly, script);
        sb.append(textArea);
        if (!BcStringUtil.isEmpty(label)) {
            globalAttribute = new HtmlGlobalAttribute();
            globalAttribute.clazz = MdlConstants.MdlClass.mdl_textfield__label.toString();
            sb.append(this.getHtmlBuilder().label_start(globalAttribute, inputName));
            sb.append(label);
            sb.append(this.getHtmlBuilder().label_end());
        }
        sb.append(this.getHtmlBuilder().div_end());
        return sb;
    }

    public StringBuilder radioButton(String name, Object value, boolean checked, String elementId, String labelValue) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = BcStringUtil.toSsv(new Object[]{MdlConstants.MdlClass.mdl_radio, MdlConstants.MdlClass.mdl_js_radio, MdlConstants.MdlClass.mdl_js_ripple_effect});
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlBuilder().label_start(globalAttribute, elementId));
        globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = BcStringUtil.toSsv(new Object[]{MdlConstants.MdlClass.mdl_radio__button});
        globalAttribute.id = elementId;
        boolean disabled = false;
        String script = null;
        sb.append(this.getHtmlBuilder().radioButton(globalAttribute, name, value, disabled, checked, script));
        globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = BcStringUtil.toSsv(new Object[]{MdlConstants.MdlClass.mdl_radio__label});
        sb.append((CharSequence)this.getHtmlBuilder().span_start(globalAttribute));
        sb.append(labelValue);
        sb.append(this.getHtmlBuilder().span_end());
        sb.append(this.getHtmlBuilder().label_end());
        return sb;
    }

    public StringBuilder checkBox(String name, Object value, boolean checked, String elementId, String labelValue) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = BcStringUtil.toSsv(new Object[]{MdlConstants.MdlClass.mdl_checkbox, MdlConstants.MdlClass.mdl_js_checkbox, MdlConstants.MdlClass.mdl_js_ripple_effect});
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlBuilder().label_start(globalAttribute, elementId));
        globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = BcStringUtil.toSsv(new Object[]{MdlConstants.MdlClass.mdl_checkbox__input});
        globalAttribute.id = elementId;
        boolean disabled = false;
        String script = null;
        sb.append(this.getHtmlBuilder().checkBox(globalAttribute, name, value, disabled, checked, script));
        globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = BcStringUtil.toSsv(new Object[]{MdlConstants.MdlClass.mdl_checkbox__label});
        sb.append((CharSequence)this.getHtmlBuilder().span_start(globalAttribute));
        sb.append(labelValue);
        sb.append(this.getHtmlBuilder().span_end());
        sb.append(this.getHtmlBuilder().label_end());
        return sb;
    }

    public String rippleButtonClass(boolean isTouchDevice) throws Exception {
        return BcStringUtil.toSsv(new Object[]{MdlConstants.MdlClass.mdl_button, MdlConstants.MdlClass.mdl_js_button, MdlConstants.MdlClass.mdl_button__raised}).toString();
    }

    public StringBuilder button_start(String onclickAction, boolean isClose, boolean isShowModal) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = this.rippleButtonClass(false);
        if (isClose) {
            globalAttribute.clazz = this.getHtmlBuilder().appendClass(globalAttribute.clazz, "close");
        }
        if (isShowModal) {
            globalAttribute.id = "dialog_button_1";
        }
        StringBuilder sb = new StringBuilder();
        HtmlConstants.HtmlButtonType buttonType = HtmlConstants.HtmlButtonType.button;
        sb.append(this.getHtmlBuilder().button_start(globalAttribute, buttonType, null, null, false, onclickAction));
        return sb;
    }

    public StringBuilder button(String text, String onclickAction, boolean isClose, boolean isShowModal) throws Exception {
        StringBuilder sb = this.button_start(onclickAction, isClose, isShowModal);
        if (!BcStringUtil.isEmpty(text)) {
            sb.append(HtmlUtil.encode(text));
        }
        sb.append(this.getHtmlBuilder().button_end());
        sb.append(this.getHtmlBuilder().appLineSep());
        return sb;
    }

    public StringBuilder button(String text, String onclickAction) throws Exception {
        return this.button(text, onclickAction, false, false);
    }

    public StringBuilder button_close(String text) throws Exception {
        boolean isClose = true;
        boolean isShowModal = false;
        return this.button(text, null, isClose, isShowModal);
    }

    public StringBuilder button_showModal(String text) throws Exception {
        boolean isClose = false;
        boolean isShowModal = true;
        return this.button(text, null, isClose, isShowModal);
    }

    public String colorText(MdlConstants.MdlColor color, MdlConstants.MdlColorNum colorNum) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("mdl-color-text--");
        sb.append(color.value);
        sb.append("-");
        sb.append(colorNum.value);
        return sb.toString();
    }

    public StringBuilder dialog(CharSequence content) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.id = "dialog_1";
        globalAttribute.clazz = BcStringUtil.toSsv(new Object[]{MdlConstants.MdlClass.mdl_dialog});
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlBuilder().dialog_start(globalAttribute));
        BcStringUtil.append(sb, content);
        sb.append(this.getHtmlBuilder().dialog_end());
        return sb;
    }

    public StringBuilder dialog(String title, String msg1, String actions2) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<h5 class=\"mdl-dialog__title\">" + HtmlUtil.encode(title) + "</h5>" + "\n<div class=\"mdl-dialog__content\">" + "\n<p>" + HtmlUtil.encode(msg1) + "\n</p>" + "\n</div>" + "\n<div class=\"mdl-dialog__actions\">" + "\n" + actions2 + "\n</div>" + "\n");
        sb = this.dialog(sb);
        return sb;
    }

    public String getDialogScript() throws Exception {
        if (this.dialogScript == null) {
            byte[] bytes = BcStreamUtil.readWithClose(this.getClass().getResourceAsStream("dialog1.js"));
            this.dialogScript = this.getHtmlBuilder().script(new String(bytes));
        }
        return this.dialogScript;
    }

    private static final class SingletonHolder {
        private static final MdlCreator instance = new MdlCreator();

        private SingletonHolder() {
        }
    }
}

