// 初期化（一度だけ）
function ext_initialize() {
  logger.info('initializing...');
  ext_initialize2();

  const executeButton = document.getElementById('executeButton');
  const textArea = document.getElementById("WbsSentence.sentence__eid");
  textArea.addEventListener("keyup", (ev) => {
    //resultKeyup.innerHTML = ev.target.value;
    //logger.debug('ev.target.value='+ev.target.value);
    if (textArea.value.length > 0) {
      executeButton.disabled = false;
    } else {
      executeButton.disabled = true;
    }
  });

  textArea.addEventListener('paste', (ev) => {
    //logger.debug('ev='+ev);
    setTimeout(function(e){
      logger.debug('textArea.value.length='+textArea.value.length);
      if (textArea.value.length > 0) {
        executeButton.disabled = false;
      } else {
        executeButton.disabled = true;
      }
    }, 100, event);
  });
  logger.info('initialized.');
}


function ext_initialize2() {
  hideProgressTag();
  hideResultDiv();
  const executeButton = document.getElementById('executeButton');
  //executeButton.disabled = true;
  executeButton.textContent = '実行'

  const textArea = document.getElementById("WbsSentence.sentence__eid");
  textArea.value = null;
}


let flag = 1;

function ext_started() {
  logger.debug('ext_started');
  setProgress(-1, null);
  const executeButton = document.getElementById('executeButton');
  executeButton.disabled = true;
} 


function tmp_start2() {
  if (flag == 1) {
    ext_started();
    submit();
  } else {
    ext_initialize2();
    flag = 1;
  }
}


async function submit() {

  const form = document.getElementById('form1');
  //const submitter = document.querySelector('button[value=save]');
  //const formData = new FormData(form, submitter);
  const formData = new FormData(form);

  try {
    // Content-type に multipart/form-data を設定してはいけない
    const response = await fetch('${submitUrl}', {
      method: 'POST',
      body: formData,
    });
    logger.debug('response.ok='+response.ok);
    if (response.ok) {
      const progress = await response.json();
      submited(progress)
    } else {
      alert('正常なレスポンスではありません');
    }
  } catch (ex) {
    alert('ex='+ex);
  }

}


// Submit完了後
function submited(progress) {
  logger.info('submited.');
  logger.debug('progress.statusId='+progress.statusId);
  logger.debug('progress.data='+progress.data);
  if (progress.statusId == ProgressStatus.OK) {
    getProgress(progress.data)
  } else {
    handleException(progress.message);
  }
}



function ext_finished(progress) {
  logger.info('finished.');
  hideProgressTag()
  displayResultDiv();
  const textArea = document.getElementById('conveted__eid');
  //textArea.style.visibility = 'visible';
  textArea.value = progress.data;

  const executeButton = document.getElementById('executeButton');
  executeButton.disabled = false;
  executeButton.textContent = '戻る'
  flag = 2;
}



function handleException(message) {
  logger.error('message='+message);
  setProgress(0, message)
}


ext_initialize();