let pFlag = true;
let baseUrl = '${baseUrl}';

async function getProgress(token) {
  pFlag = true;
  let pollingCnt = 0;
  const polling = () => {
    setTimeout(async () => {
      if (!pFlag) {
        return;
      }
      pollingCnt++;
      try {
        await getProgress2(pollingCnt, token);
      } catch (error) {
        console.error('Error occurred:'+error);
        handleException(error);
        return;
      }
      polling();
    }, ${interval})
  }
  polling();
}


async function getProgress2(pollingCnt, token) {
  const url = baseUrl + token;
  const res = await fetch(url);
  if (!res.ok) {
    throw new Error(`Abnormal response: ${res.status}`);
  }

  const progress = await res.json();
  logger.debug('['+pollingCnt+'] message='+progress.message);

  if (progress.statusId == ProgressStatus.OK) {
    setProgress(progress.percent, progress.message);
  } else if (progress.statusId == ProgressStatus.Finished) {
    pFlag = false;
    ext_finished(progress);
  } else {
    pFlag = false;
    handleException(progress.message);
  }
}


async function check1(token) {
  const url = baseUrl + token;

  return new Promise((resolve) => {
    fetch(url)
      .then((response, reject) => {
        resolve('result');
     });
  });
}

async function check2(token) {
  const url = baseUrl + token;

  fetch(url)
    .then(response => {
      return response.json();
    })
    .then(data => {
      console.log('data='+data);
      let obj2 = JSON.parse(data);
      console.log('obj2='+obj2);
    })
    .catch(error => {
      console.log('failure');
  });
}


//--------------------------------------------------
// progressTag
//--------------------------------------------------
function displayProgressTag() {
  const progressTag = document.getElementById('progressTag');
  progressTag.style.visibility = 'visible';

  const progressMessage = document.getElementById('progressMessage');
  progressMessage.style.visibility = 'visible';

  const progressLabel = document.getElementById('progressLabel');
  progressLabel.style.visibility = 'visible';
}

function hideProgressTag() {
  const progressTag = document.getElementById('progressTag');
  progressTag.style.visibility = 'hidden';

  const progressMessage = document.getElementById('progressMessage');
  progressMessage.style.visibility = 'hidden';

  const progressLabel = document.getElementById('progressLabel');
  progressLabel.style.visibility = 'hidden';
}

function setProgress(value, message) {
  logger.debug('setProgress:value='+value+' message='+message);
  displayProgressTag();
  const progressTag = document.getElementById('progressTag');

  let percent = -1;
  if (value >= 0) {
    progressTag.value = value;
    percent = value/progressTag.max *100;
  }

  const progressMessage = document.getElementById('progressMessage');
  progressMessage.innerText = message;

  const progressLabel = document.getElementById('progressLabel');
  if (percent >= 0) {
    let lavel = String(ExMath.round(percent, 1)) + '%';
    progressLabel.innerText = lavel;
  }
}


//--------------------------------------------------
// resultDiv
//--------------------------------------------------
function displayResultDiv() {
  const resultDiv = document.getElementById('resultDiv');
  //resultDiv.style.visibility = 'visible';
  resultDiv.style.display = 'block';
}

function hideResultDiv() {
  const resultDiv = document.getElementById('resultDiv');
  //resultDiv.style.visibility = 'hidden';
  resultDiv.style.display = 'none';
}

