$(document).ready(function(){

$('${selector}').DataTable({
  ajax: {
     url: '${ajaxUrl}',
     type: 'POST'
  },

  fixedHeader: {
    header: true,
    footer: true
  },

  scrollCollapse: true,
  //scroller: true,
  scrollY: '50vh',
  scrollX: true,
  processing: true,
  responsive: true,

  select: true,
  //ordering: true,
  order: [],
  //rowReorder: true,

  paging: true,
  lengthChange: true,
  displayLength: ${displayLength},
  lengthMenu: ${lengthMenu},

  searching: true,
  search: {
    return: true
  },

  language: {
    emptyTable: 'The data is empty.',
    info: '${info}',
    infoEmpty: '',
    loadingRecords: 'Loading...',
    processing: 'Processing...',
  },
  ${columnDefs},

  layout: {
    topStart: 'info',
    topEnd: 'paging',
    top2Start: 'pageLength',
    top2End: 'search',
    bottomStart: {
      buttons: ['csv']
    },
    bottomEnd: 'paging'
  },  

  serverSide: ${serverSide},
});



$('${selector}').on('xhr.dt', function (e, settings, json, xhr) {
  if (xhr.status != 200) {
    console.log('xhr.status=', xhr.status);
    console.log('xhr.responseJSON=', xhr.responseJSON);
    alert(xhr.responseJSON);
  }
  // error.dtイベントの発生を無効化するにはtrueを返却する。
  return true;
  //return false;
});


// エラー発生時にデフォルトで表示されるメッセージボックスを無効化する。
$.fn.dataTable.ext.errMode = 'none';
//$.fn.DataTable.ext.errMode = 'throw';

// errorイベントを受け取るハンドラ（エラーレスポンスの取得はできない。）
$('${selector}').on('error.dt', function (e, settings, techNote, message) {
  console.log('error DataTables: ', message);
})

});
