/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.Cipher;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public class EncryptedPrivateKeyInfo {
    private AlgorithmId algid;
    private byte[] encryptedData;
    private byte[] encoded = null;

    public EncryptedPrivateKeyInfo(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("the encoded parameter must be non-null");
        }
        this.encoded = (byte[])byArray.clone();
        DerValue derValue = new DerValue(this.encoded);
        if (derValue.tag != 48) {
            throw new IOException("DER header error: no SEQ tag");
        }
        DerValue[] derValueArray = new DerValue[]{derValue.data.getDerValue(), derValue.data.getDerValue()};
        if (derValue.data.available() != 0) {
            throw new IOException("overrun, bytes = " + derValue.data.available());
        }
        this.algid = AlgorithmId.parse(derValueArray[0]);
        if (derValueArray[0].data.available() != 0) {
            throw new IOException("encryptionAlgorithm field overrun");
        }
        this.encryptedData = derValueArray[1].getOctetString();
        if (derValueArray[1].data.available() != 0) {
            throw new IOException("encryptedData field overrun");
        }
    }

    public EncryptedPrivateKeyInfo(String string, byte[] byArray) throws NoSuchAlgorithmException {
        if (string == null) {
            throw new NullPointerException("the algName parameter must be non-null");
        }
        this.algid = AlgorithmId.get(string);
        if (byArray == null) {
            throw new NullPointerException("the encryptedData parameter must be non-null");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("the encryptedData parameter must not be empty");
        }
        this.encryptedData = (byte[])byArray.clone();
        this.encoded = null;
    }

    public EncryptedPrivateKeyInfo(AlgorithmParameters algorithmParameters, byte[] byArray) throws NoSuchAlgorithmException {
        if (algorithmParameters == null) {
            throw new NullPointerException("algParams must be non-null");
        }
        this.algid = AlgorithmId.get(algorithmParameters);
        if (byArray == null) {
            throw new NullPointerException("encryptedData must be non-null");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("the encryptedData parameter must not be empty");
        }
        this.encryptedData = (byte[])byArray.clone();
        this.encoded = null;
    }

    public String getAlgName() {
        return this.algid.getName();
    }

    public AlgorithmParameters getAlgParameters() {
        return this.algid.getParameters();
    }

    public byte[] getEncryptedData() {
        return (byte[])this.encryptedData.clone();
    }

    public PKCS8EncodedKeySpec getKeySpec(Cipher cipher) throws InvalidKeySpecException {
        byte[] byArray = null;
        try {
            byArray = cipher.doFinal(this.encryptedData);
            EncryptedPrivateKeyInfo.checkPKCS8Encoding(byArray);
        }
        catch (IOException | IllegalStateException | GeneralSecurityException exception) {
            throw new InvalidKeySpecException("Cannot retrieve the PKCS8EncodedKeySpec", exception);
        }
        return new PKCS8EncodedKeySpec(byArray);
    }

    private PKCS8EncodedKeySpec getKeySpecImpl(Key key, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] byArray = null;
        try {
            Cipher cipher = provider == null ? Cipher.getInstance(this.algid.getName()) : Cipher.getInstance(this.algid.getName(), provider);
            cipher.init(2, key, this.algid.getParameters());
            byArray = cipher.doFinal(this.encryptedData);
            EncryptedPrivateKeyInfo.checkPKCS8Encoding(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw noSuchAlgorithmException;
        }
        catch (IOException | GeneralSecurityException exception) {
            throw new InvalidKeyException("Cannot retrieve the PKCS8EncodedKeySpec", exception);
        }
        return new PKCS8EncodedKeySpec(byArray);
    }

    public PKCS8EncodedKeySpec getKeySpec(Key key) throws NoSuchAlgorithmException, InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("decryptKey is null");
        }
        return this.getKeySpecImpl(key, null);
    }

    public PKCS8EncodedKeySpec getKeySpec(Key key, String string) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("decryptKey is null");
        }
        if (string == null) {
            throw new NullPointerException("provider is null");
        }
        Provider provider = Security.getProvider(string);
        if (provider == null) {
            throw new NoSuchProviderException("provider " + string + " not found");
        }
        return this.getKeySpecImpl(key, provider);
    }

    public PKCS8EncodedKeySpec getKeySpec(Key key, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("decryptKey is null");
        }
        if (provider == null) {
            throw new NullPointerException("provider is null");
        }
        return this.getKeySpecImpl(key, provider);
    }

    public byte[] getEncoded() throws IOException {
        if (this.encoded == null) {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.algid.encode(derOutputStream2);
            derOutputStream2.putOctetString(this.encryptedData);
            derOutputStream.write((byte)48, derOutputStream2);
            this.encoded = derOutputStream.toByteArray();
        }
        return (byte[])this.encoded.clone();
    }

    private static void checkTag(DerValue derValue, byte by, String string) throws IOException {
        if (derValue.getTag() != by) {
            throw new IOException("invalid key encoding - wrong tag for " + string);
        }
    }

    private static void checkPKCS8Encoding(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(3);
        switch (derValueArray.length) {
            case 4: {
                EncryptedPrivateKeyInfo.checkTag(derValueArray[3], (byte)-128, "attributes");
            }
            case 3: {
                EncryptedPrivateKeyInfo.checkTag(derValueArray[0], (byte)2, "version");
                DerInputStream derInputStream2 = derValueArray[1].toDerInputStream();
                derInputStream2.getOID();
                if (derInputStream2.available() != 0) {
                    derInputStream2.getDerValue();
                }
                EncryptedPrivateKeyInfo.checkTag(derValueArray[2], (byte)4, "privateKey");
                break;
            }
            default: {
                throw new IOException("invalid key encoding");
            }
        }
    }
}

