/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output;

import javax.servlet.ServletContext;
import org.apache.log.format.Formatter;
import org.apache.log.output.AbstractOutputTarget;

public class ServletOutputLogTarget
extends AbstractOutputTarget {
    private ServletContext m_context;

    public ServletOutputLogTarget(ServletContext context, Formatter formatter) {
        super(formatter);
        this.m_context = context;
        this.open();
    }

    public ServletOutputLogTarget(ServletContext context) {
        this.m_context = context;
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write(String message) {
        char prev;
        int len = message.length();
        char last = len > 0 ? message.charAt(len - 1) : (char)'\u0000';
        char c = prev = len > 1 ? message.charAt(len - 2) : (char)'\u0000';
        String trimmedMessage = prev == '\r' && last == '\n' ? message.substring(0, len - 2) : (last == '\n' ? message.substring(0, len - 1) : message);
        ServletContext context = this.m_context;
        if (context != null) {
            ServletContext servletContext = context;
            synchronized (servletContext) {
                context.log(trimmedMessage);
            }
        }
    }

    @Override
    public synchronized void close() {
        super.close();
        this.m_context = null;
    }
}

