/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.swing.docviewer;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import jp.co.extreme.awt.AwtImageHelper;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.doc.util.DcfBookFile;
import jp.co.extreme.doc.util.DcfPageReader;
import jp.co.extreme.pdf.PdfBookConverter;
import jp.co.extreme.pdf.PdfConstants;
import jp.co.extreme.pdf.object.PdfInformation;
import jp.co.extreme.swing.SwgComboBox;
import jp.co.extreme.swing.SwgDecoratePanel;
import jp.co.extreme.swing.SwgDialog;
import jp.co.extreme.swing.SwgFileChooser;
import jp.co.extreme.swing.SwgTextField;
import jp.co.extreme.swing.SwgUtil;

public class DcfPdfDilog
extends SwgDecoratePanel {
    private static final long serialVersionUID = 8824895699647148289L;
    protected SwgComboBox formatVersionCombo = new SwgComboBox();
    protected SwgTextField destFilePathField = new SwgTextField();
    protected SwgTextField titleField = new SwgTextField();
    protected SwgTextField subTitleField = new SwgTextField();
    protected SwgTextField authorField = new SwgTextField();
    protected SwgFileChooser fileChooser = new SwgFileChooser();
    protected String[] formatNames = new String[]{"PDF Ver 1.2"};
    protected File zipFile;
    protected DcfPageReader pageReader;
    public boolean formatVersionFlag = false;
    public boolean titleFlag = false;
    protected Window window;

    public DcfPdfDilog() throws Exception {
        this.setBorderSize(20, 40, 0, 0);
        this.setOkButton(BcWords.getInstance().completion);
        this.setCancelButton(BcWords.getInstance().cancel);
        this.setDescription("PDF \u51fa\u529b\u306b\u95a2\u3059\u308b\u8a2d\u5b9a\u3092\u884c\u3063\u3066\u4e0b\u3055\u3044\u3002");
        this.setLine();
        this.fileChooser.setDialogTitle("PDF \u30d5\u30a1\u30a4\u30eb\u306e\u9078\u629e");
        this.fileChooser.setDialogType(1);
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setMultiSelectionEnabled(false);
        this.initComponent();
        SwgUtil.setCenter(this, 640.0, 420.0);
        this.zipFile = null;
        this.pageReader = null;
    }

    protected void initComponent() {
        int rowHeight = SwgUtil.getTextFieldHeight(this.getFont(), null);
        int rowHeight2 = SwgUtil.getBrowsButtonHeight(this.getFont(), null);
        int rowGap = SwgUtil.getRowDiff(this.getFont());
        int colGap = SwgUtil.getColDiff(this.getFont());
        int c1w = 100;
        int c1x = 8;
        int c2x = c1x + c1w + colGap;
        int ly = 8;
        if (this.formatVersionFlag) {
            SwgUtil.setLocation(this.centerPanel, new JLabel(BcWords.getInstance().format, 4), (double)c1x, (double)ly, (double)c1w, (double)rowHeight2);
            SwgUtil.setLocation(this.centerPanel, this.formatVersionCombo, (double)c2x, (double)ly, 320.0, (double)rowHeight2);
            int i = 0;
            while (i < this.formatNames.length) {
                this.formatVersionCombo.addItem(this.formatNames[i]);
                ++i;
            }
            ly += rowHeight2 + rowGap;
            ly += rowHeight2 + rowGap;
        }
        SwgUtil.setLocation(this.centerPanel, new JLabel(BcWords.getInstance().destination, 4), (double)c1x, (double)ly, (double)c1w, (double)rowHeight2);
        SwgUtil.setLocation(this.centerPanel, this.destFilePathField, (double)c2x, (double)ly, 420.0, (double)rowHeight2);
        JButton filerButton = new JButton("\u53c2\u7167");
        SwgUtil.setLocation(this.centerPanel, filerButton, (double)(c2x + 420), (double)ly, -1.0, (double)rowHeight2);
        filerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DcfPdfDilog.this.fileChooser.resetChoosableFileFilters();
                switch (DcfPdfDilog.this.fileChooser.showDialog(DcfPdfDilog.this.window, "\u9078\u629e")) {
                    case 0: {
                        File destFile = new File(DcfPdfDilog.this.fileChooser.getSelectedFile().getPath());
                        String fileExtention = BcFileUtil.getExtention(destFile);
                        if (!BcStringUtil.equalsIgnoreCase(fileExtention, "pdf")) {
                            destFile = new File(String.valueOf(destFile.getPath()) + PdfConstants.EXTENTION_dot_pdf);
                        }
                        DcfPdfDilog.this.destFilePathField.setText(destFile.getPath());
                        break;
                    }
                }
            }
        });
        ly += rowHeight2 + rowGap;
        if (this.titleFlag) {
            SwgUtil.setLocation(this.centerPanel, new JLabel("\u30bf\u30a4\u30c8\u30eb", 4), (double)c1x, (double)ly, (double)c1w, (double)rowHeight2);
            SwgUtil.setLocation(this.centerPanel, this.titleField, (double)c2x, (double)ly, 240.0, (double)rowHeight2);
            SwgUtil.setLocation(this.centerPanel, new JLabel("\u30b5\u30d6\u30bf\u30a4\u30c8\u30eb", 4), (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight2);
            SwgUtil.setLocation(this.centerPanel, this.subTitleField, (double)c2x, (double)ly, 240.0, (double)rowHeight2);
            SwgUtil.setLocation(this.centerPanel, new JLabel("\u4f5c\u6210\u8005", 4), (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight2);
            SwgUtil.setLocation(this.centerPanel, this.authorField, (double)c2x, (double)ly, 240.0, (double)rowHeight2);
            ly += rowHeight + rowGap;
        }
    }

    @Override
    protected void okButtonAction() {
        File pdfFile = new File(this.destFilePathField.getText());
        File parentFile = pdfFile.getParentFile();
        if (parentFile != null && !parentFile.exists()) {
            parentFile.mkdirs();
        }
        PdfInformation pdfInfo = new PdfInformation();
        pdfInfo.setTitle(this.titleField.getText());
        pdfInfo.setSubject(this.subTitleField.getText());
        pdfInfo.setAuthor(this.authorField.getText());
        try {
            PdfBookConverter pdfGenerator = new PdfBookConverter();
            if (this.zipFile != null) {
                DcfBookFile bookFile = new DcfBookFile();
                bookFile.setReadMode(this.zipFile);
                pdfGenerator.createPdf(pdfInfo, (DcfPageReader)bookFile, pdfFile);
            } else {
                pdfGenerator.createPdf(pdfInfo, this.pageReader, pdfFile);
            }
            this.close();
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            JOptionPane.showConfirmDialog(this, ex.toString(), BcWords.getInstance().exception, 0);
        }
    }

    @Override
    protected void cancelButtonAction() throws Exception {
        this.close();
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.window.dispose();
    }

    public void showAsDialog(File zipFile, File destFile, String title, Component ownerCompo) throws Exception {
        this.zipFile = zipFile;
        if (destFile != null) {
            this.destFilePathField.setText(destFile.getPath());
        }
        SwgDialog dialog = SwgUtil.createDialog(ownerCompo);
        dialog.getContentPane().add((Component)this, "Center");
        dialog.setModal(true);
        dialog.setResizable(false);
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                try {
                    DcfPdfDilog.this.cancelButtonAction();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.window = dialog;
        dialog.setTitle(title);
        dialog.setIconImage(AwtImageHelper.getWindowIconImage());
        SwgUtil.setCenter(dialog, 660.0, 400.0);
        dialog.setVisible(true);
    }

    public void showAsDialog(DcfPageReader pageFiler, File destFile, String title, Component ownerCompo) throws Exception {
        this.pageReader = pageFiler;
        if (destFile != null) {
            this.destFilePathField.setText(destFile.getPath());
        }
        SwgDialog dialog = SwgUtil.createDialog(ownerCompo);
        dialog.getContentPane().add((Component)this, "Center");
        dialog.setModal(true);
        dialog.setResizable(false);
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                try {
                    DcfPdfDilog.this.cancelButtonAction();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.window = dialog;
        dialog.setTitle(title);
        dialog.setIconImage(AwtImageHelper.getWindowIconImage());
        SwgUtil.setCenter(dialog, 660.0, 400.0);
        dialog.setVisible(true);
    }
}

