/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.swing;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.Calendar;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.core.BcTimeUtil_JP;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.swing.SwgMenuItem;
import jp.co.extreme.swing.SwgTextField;
import jp.co.extreme.swing.SwgUtil;

public class SwgDateField
extends SwgTextField {
    private static final long serialVersionUID = -3604739015896050664L;
    protected Calendar calendar;
    protected String format;
    protected SwgMenuItem menu_setNow;
    protected String toolTip;
    protected int mode;

    public SwgDateField(int mode, String format) throws Exception {
        this.mode = mode;
        this.init();
        this.setFormat(format);
    }

    public SwgDateField() throws Exception {
        this.mode = 1;
        this.setFormat("yyyy/MM/dd");
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.menu_setNow = new SwgMenuItem();
        this.toolTip = this.mode == 11 ? "yyyy/MM, yyyyMM \u306e\u3044\u305a\u308c\u304b\u306e\u5f62\u5f0f\u3067\u5165\u529b\u3057\u3066\u4e0b\u3055\u3044\u3002" : "yyyy/MM/dd, yyyyMMdd \u306e\u3044\u305a\u308c\u304b\u306e\u5f62\u5f0f\u3067\u5165\u529b\u3057\u3066\u4e0b\u3055\u3044\u3002";
        this.popupMenu.addSeparator();
        this.menu_setNow.addActionListener(this.actionListener);
        this.popupMenu.add(this.menu_setNow);
        this.setToolTipText(this.toolTip);
        this.setImeMode(1);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) throws Exception {
        this.format = format;
        if (this.calendar != null) {
            this.setCalendar(this.calendar);
        }
        this.setFont(this.getFont());
    }

    @Override
    public void actionPerformed2(ActionEvent ev) throws Exception {
        super.actionPerformed2(ev);
        if (ev.getSource() == this.menu_setNow) {
            this.setText(BcTimeUtil.toString(BcTimeUtil.createCalendar(), this.getFormat()));
        }
    }

    @Override
    public void setText(String text) {
        this.calendar = null;
        if (BcStringUtil.isEmpty(text)) {
            super.setText("");
            return;
        }
        if (this.mode == 11) {
            if (text.matches("[0-9]{2,4}/[0-9]{1,2}")) {
                text = String.valueOf(text) + "/01";
            } else if (text.matches("[0-9]{5,6}")) {
                text = String.valueOf(text) + "01";
            }
        }
        try {
            this.calendar = BcTimeUtil.toCalendar(text);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.calendar != null) {
            super.setText(BcTimeUtil.toString(this.calendar, this.getFormat()));
            try {
                String toolTip = "<html>" + BcTimeUtil_JP.toJpString(this.calendar);
                this.setToolTipText(toolTip);
            }
            catch (Exception toolTip) {}
        } else if (BcStringUtil.equals(text, "9999/99/99")) {
            try {
                this.calendar = BcTimeUtil.toCalendar(99999999);
                super.setText(text);
            }
            catch (Exception ex) {
                BcLogUtil.debug(ex);
            }
        } else {
            super.setText("");
        }
    }

    @Override
    public void focusEvent(FocusEvent ev) {
        super.focusEvent(ev);
        switch (ev.getID()) {
            case 1005: {
                if (this.popupFlag) break;
                this.setText(this.getText());
            }
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (!BcStringUtil.isEmpty(this.getFormat())) {
            Dimension dim = SwgUtil.getTextFieldSize(this.getFont(), this.getFormat());
            this.setPreferredSize(dim);
        }
    }

    @Override
    public void setPopupMenuAttribute() {
        this.menu_setNow.setText("\u672c\u65e5(" + BcTimeUtil.toString(BcTimeUtil.createCalendar(), "yyyy/MM/dd") + ")\u306b\u8a2d\u5b9a");
        this.menu_setNow.setEnabled(super.isEnabled() && super.isEditable());
        super.setPopupMenuAttribute();
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void setCalendar(Calendar calendar) {
        int yyyyMMdd = BcTimeUtil.toYyyyMMdd(calendar);
        if (calendar == null) {
            this.setText(null);
        } else if (BcTimeUtil.isMaxDate(calendar)) {
            this.setText("9999/99/99");
        } else {
            this.setText(BcTimeUtil.toString(calendar, this.format));
        }
    }

    public int getYyyyMMdd() throws Exception {
        return BcTimeUtil.toYyyyMMdd(this.calendar);
    }

    public void setYyyyMMdd(int yyyyMMdd) throws Exception {
        Calendar calendar = BcTimeUtil.toCalendar(yyyyMMdd);
        this.setCalendar(calendar);
    }
}

