/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf8.swg;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import jp.co.extreme.awt.AwtImageHelper;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.table.BcTableContext;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.table.BcTableUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.scf.client.ScfClientContainer;
import jp.co.extreme.scf6.client.RmiTableLoader;
import jp.co.extreme.scf8.swg.KswgMasterControl;
import jp.co.extreme.swing.SwgButton;
import jp.co.extreme.swing.SwgControlPanel;
import jp.co.extreme.swing.SwgDecoratePanel;
import jp.co.extreme.swing.SwgDialog;
import jp.co.extreme.swing.SwgTableView;
import jp.co.extreme.swing.SwgTableViewUtil;
import jp.co.extreme.swing.SwgUtil;

public class KswgAbstractTableSelectPanel
extends SwgDecoratePanel
implements ListSelectionListener {
    protected KswgMasterControl masterControl;
    protected BcTableModel tableModel;
    protected BcTableColumnModel tableColumnModel;
    protected BcTableContext tableContext;
    protected SwgTableView tableView;
    protected JScrollPane tableViewScrollPane = new JScrollPane();
    protected SwgControlPanel controlPanel;
    protected SwgButton reloadButton;
    protected SwgButton selectButton;
    protected SwgButton selectCancelButton;
    protected SwgButton closeButton;
    protected RmiRequest orgReq;
    protected Window window;

    public KswgAbstractTableSelectPanel(KswgMasterControl masterControl) throws Exception {
        this.reloadButton = new SwgButton(BcWords.getInstance().refresh);
        this.selectButton = new SwgButton(BcWords.getInstance().select);
        this.selectCancelButton = new SwgButton(BcWords.getInstance().clearSelection);
        this.closeButton = new SwgButton(BcWords.getInstance().close);
        this.masterControl = masterControl;
        this.controlPanel = new SwgControlPanel();
        this.setFont(masterControl.getFont());
        this.centerPanel.setLayout(new BorderLayout());
        this.controlPanel.setPreferredSize(new Dimension(10, 64));
        this.centerPanel.add((Component)this.controlPanel, "South");
        this.selectButton.addActionListener(this.actionListener);
        this.controlPanel.add((Component)this.selectButton, -1);
        this.selectCancelButton.addActionListener(this.actionListener);
        this.controlPanel.add((Component)this.selectCancelButton, -1);
        this.closeButton.addActionListener(this.actionListener);
        this.controlPanel.add((Component)this.closeButton, -1);
    }

    protected void loadData(RmiRequest rmiReq) throws Exception {
        Object preKeyObj = null;
        int viewRowIdx = -1;
        if (this.tableView != null && (viewRowIdx = this.tableView.getSelectedRow()) >= 0) {
            preKeyObj = this.tableView.getValueAt(viewRowIdx, 0);
        }
        this.tableColumnModel = new BcTableColumnModel();
        this.tableModel = new BcTableModel(this.tableColumnModel);
        this.tableContext = new BcTableContext();
        RmiTableLoader tableLoader = new RmiTableLoader(ScfClientContainer.getInstance().getAgent());
        tableLoader.loadTable(this.tableModel, this.tableContext, rmiReq);
        this.tableView = new SwgTableView(this.tableModel, this.tableColumnModel);
        this.tableView.setSelectionMode(0);
        this.tableView.addListSelectionListener(this);
        this.tableView.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent ev) {
                KswgAbstractTableSelectPanel.this.mouseClickedEvent(ev);
            }
        });
        this.tableView.setFont(this.getFont());
        if (this.tableViewScrollPane != null) {
            this.centerPanel.remove(this.tableViewScrollPane);
        }
        this.tableViewScrollPane.getViewport().add(this.tableView);
        this.tableViewScrollPane.setFont(this.getFont());
        this.centerPanel.add((Component)this.tableViewScrollPane, "Center");
        this.northPanel.removeAll();
        this.northPanel.setPreferredSize(new Dimension(8, 32));
        this.centerPanel.add((Component)this.northPanel, "North");
        if (this.tableContext.getConditionList() != null) {
            SwgTableView conditionTableView = SwgTableViewUtil.createConditionTableView(this.tableContext);
            conditionTableView.setSelectionBackground(new Color(230, 230, 230));
            conditionTableView.setSelectionForeground(Color.darkGray);
            double height = conditionTableView.getRowHeight() * conditionTableView.getRowCount();
            SwgUtil.setLocation(this.northPanel, conditionTableView, 8.0, 8.0, 380.0, height);
            height += 8.0;
            if (height > this.northPanel.getPreferredSize().getHeight()) {
                this.northPanel.setPreferredSize(new Dimension(8, (int)height));
            }
        }
        this.dataLoaded();
        this.validate();
        if (preKeyObj != null && (viewRowIdx = BcTableUtil.getRowIndex((TableModel)this.tableModel, 0, preKeyObj)) >= 0) {
            this.tableView.setRowSelectionInterval(viewRowIdx, viewRowIdx);
        }
    }

    protected void dataLoaded() throws Exception {
        SwgTableViewUtil.setEditable(this.tableColumnModel, false);
        if (this.tableModel.getRowCount() > 0) {
            this.selectButton.setEnabled(true);
            this.tableView.setRowSelectionInterval(0, 0);
        } else {
            this.selectButton.setEnabled(false);
        }
    }

    protected void setTableColor(SwgTableView tableView) {
        tableView.setBackground(new Color(128, 192, 192));
        tableView.setForeground(Color.darkGray);
    }

    @Override
    public void valueChanged(ListSelectionEvent ev) {
        if (ev.getValueIsAdjusting()) {
            return;
        }
        this.selectButton.setEnabled(false);
        int[] rowViewIdxs = this.tableView.getSelectedRows();
        if (rowViewIdxs.length > 0 && rowViewIdxs.length == 1) {
            this.selectButton.setEnabled(true);
        }
    }

    @Override
    protected void actionPerformed2(ActionEvent ev) throws Exception {
        super.actionPerformed2(ev);
        if (ev.getSource() == this.reloadButton) {
            this.loadData(this.orgReq);
        } else if (ev.getSource() == this.selectButton) {
            int[] rowViewIdxs = this.tableView.getSelectedRows();
            if (rowViewIdxs.length == 1) {
                this.dataSelected(rowViewIdxs[0]);
            }
        } else if (ev.getSource() == this.selectCancelButton) {
            this.close();
        } else if (ev.getSource() == this.closeButton) {
            this.close();
        }
    }

    protected void mouseClickedEvent(MouseEvent ev) {
        if (ev.getClickCount() != 2) {
            return;
        }
        int rowViewIdx = this.tableView.rowAtPoint(ev.getPoint());
        try {
            this.dataSelected(rowViewIdx);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }

    protected void dataSelected(int rowViewIdx) throws Exception {
        int columnIndex = this.tableColumnModel.getIndexByTableColumnName(this.masterControl.getColumneName_id());
        if (columnIndex >= 0) {
            Object dataId = this.tableView.getValueAt(rowViewIdx, columnIndex);
            this.masterControl.setDataId(dataId);
        }
        if ((columnIndex = this.tableColumnModel.getIndexByTableColumnName(this.masterControl.getColumneName_code())) >= 0) {
            Object code = this.tableView.getValueAt(rowViewIdx, columnIndex);
            this.masterControl.setDataCode(code);
        }
        if ((columnIndex = this.tableColumnModel.getIndexByTableColumnName(this.masterControl.getColumneName_name())) >= 0) {
            Object name = this.tableView.getValueAt(rowViewIdx, columnIndex);
            this.masterControl.setDataName(name);
        }
        this.close();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.tableView != null) {
            this.tableView.setFont(font);
        }
        if (this.tableViewScrollPane != null) {
            this.tableViewScrollPane.setFont(font);
        }
        if (this.reloadButton != null) {
            this.reloadButton.setFont(font);
            this.selectButton.setFont(font);
            this.selectCancelButton.setFont(font);
            this.closeButton.setFont(font);
            this.controlPanel.repaint();
        }
    }

    @Override
    protected void cancelButtonAction() {
        this.close();
    }

    @Override
    public void close() {
        this.window.dispose();
    }

    public void showAsDialog(Component parentCompo) throws Exception {
        SwgDialog dialog = SwgUtil.createDialog(parentCompo);
        dialog.getContentPane().add((Component)this, "Center");
        dialog.setModal(true);
        dialog.setResizable(true);
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                KswgAbstractTableSelectPanel.this.cancelButtonAction();
            }
        });
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int fWidth = 0;
        int fHeight = 0;
        if (dim.getWidth() >= 1024.0) {
            fWidth = 960;
            fHeight = 680;
        } else {
            fWidth = 780;
            fHeight = 540;
        }
        dialog.setIconImage(AwtImageHelper.getWindowIconImage());
        this.window = dialog;
        SwgUtil.setSelectWindow(this.window);
        this.window.setVisible(true);
    }
}

