/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf8.cluster.controller;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.net.BcAddressPort;
import jp.co.extreme.base.thread.BcThread;
import jp.co.extreme.base.util.BcReflectUtil;
import jp.co.extreme.scf8.cluster.common.KscfClusterNode;
import jp.co.extreme.scf8.cluster.controller.KscfClusterController;
import jp.co.extreme.scf8.cluster.controller.KscfMulticastData;
import jp.co.extreme.scf8.cluster.controller.KscfMulticastReceiveHandler;

public class KscfMulticastReceiver
extends BcThread {
    protected KscfClusterController clusterController;
    protected InetAddress mcastAddress;
    protected MulticastSocket socket;
    protected int packetSize = 16384;
    protected Map<Integer, ArrayList> commandMap = new HashMap<Integer, ArrayList>();
    protected Map<String, Object> singletonMap = new HashMap<String, Object>();
    protected Map<String, Method> methodMap = new HashMap<String, Method>();

    public KscfMulticastReceiver(KscfClusterController clusterController) throws Exception {
        this.clusterController = clusterController;
    }

    public void setup(BcAddressPort multicastAddressPort) throws Exception {
        this.mcastAddress = InetAddress.getByName(multicastAddressPort.address);
        this.socket = new MulticastSocket(multicastAddressPort.port);
        this.socket.joinGroup(this.mcastAddress);
        this.setPriority(1);
        this.startThread();
    }

    @Override
    protected void run2() throws Exception {
        try {
            byte[] buf = new byte[this.packetSize];
            DatagramPacket packet = new DatagramPacket(buf, buf.length);
            this.socket.receive(packet);
            this.trans1(packet, buf);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }

    public void trans1(DatagramPacket datagramPacket, byte[] buf) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buf);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        int version = objectInputStream.readInt();
        if (version == 100) {
            KscfMulticastData multicastData = new KscfMulticastData();
            multicastData.senderNodeId = (String)objectInputStream.readObject();
            if (!BcStringUtil.equals(multicastData.senderNodeId, this.clusterController.getNodeId())) {
                multicastData.senderSeq = objectInputStream.readLong();
                multicastData.reqNodeId = (String)objectInputStream.readObject();
                multicastData.reqSeq = objectInputStream.readLong();
                multicastData.comannd = objectInputStream.readInt();
                this.trans2(multicastData, objectInputStream);
            }
        } else {
            BcLogUtil.error("cluster version error. version=" + version);
        }
        objectInputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trans2(KscfMulticastData multicastData, ObjectInputStream objectInputStream) throws Exception {
        if (multicastData.comannd == 11) {
            Object[] dataArray = (Object[])objectInputStream.readObject();
            KscfClusterNode clusterNode = new KscfClusterNode();
            clusterNode.id = multicastData.senderNodeId;
            clusterNode.lasrHeartBeat = clusterNode.entryTime = System.currentTimeMillis();
            clusterNode.type = (String)dataArray[0];
            BcLogUtil.debug("recieve:MCCMD_culuster_entry");
            BcLogUtil.debug("clusterNode.id=" + clusterNode.id);
            BcLogUtil.debug("clusterNode.type=" + clusterNode.type);
            this.clusterController.addClusterNode(clusterNode, true);
        } else if (multicastData.comannd == 21) {
            Object[] dataArray = new Object[]{this.clusterController.getNodeType()};
            this.clusterController.getSender().send(multicastData.senderNodeId, multicastData.senderSeq, 22, dataArray);
            BcLogUtil.debug("recieve:MCCMD_require");
        } else if (multicastData.comannd == 22) {
            Object[] dataArray = (Object[])objectInputStream.readObject();
            KscfClusterNode clusterNode = new KscfClusterNode();
            clusterNode.id = multicastData.senderNodeId;
            clusterNode.lasrHeartBeat = clusterNode.entryTime = System.currentTimeMillis();
            clusterNode.type = (String)dataArray[0];
            BcLogUtil.debug("recieve:MCCMD_require_res");
            BcLogUtil.debug("clusterNode.id=" + clusterNode.id);
            BcLogUtil.debug("clusterNode.type=" + clusterNode.type);
            this.clusterController.addClusterNode(clusterNode, false);
        } else if (multicastData.comannd == 51) {
            Object[] dataArray = (Object[])objectInputStream.readObject();
            KscfClusterNode clusterNode = (KscfClusterNode)this.clusterController.getCulsuterMap().get(multicastData.senderNodeId);
            if (clusterNode != null) {
                clusterNode.type = (String)dataArray[0];
                BcLogUtil.debug("recieve:MCCMD_nodoTypeUpdate");
                BcLogUtil.debug("clusterNode.type=" + clusterNode.type);
            } else {
                BcLogUtil.warning("not entry:multicastData.senderNodeId=" + multicastData.senderNodeId);
            }
        } else if (multicastData.comannd == 61) {
            this.clusterController.heartBeatRecieve(multicastData.senderNodeId);
        } else if (multicastData.comannd == 91) {
            Object entity = objectInputStream.readObject();
            this.invokeSingleton1(multicastData, entity);
        } else {
            Object entity = objectInputStream.readObject();
            objectInputStream.close();
            Object[] eventHandlerArray = null;
            Map<Integer, ArrayList> map = this.commandMap;
            synchronized (map) {
                ArrayList eventHandlerList = this.commandMap.get(multicastData.comannd);
                if (eventHandlerList != null) {
                    eventHandlerArray = eventHandlerList.toArray();
                }
            }
            if (eventHandlerArray != null) {
                int i = 0;
                while (i < eventHandlerArray.length) {
                    KscfMulticastReceiveHandler multicastReceiveHandler = (KscfMulticastReceiveHandler)eventHandlerArray[i];
                    multicastReceiveHandler.multicastPacketReceived(multicastData, entity);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventHandler(int comannd, KscfMulticastReceiveHandler multicastReceiveHandler) {
        Map<Integer, ArrayList> map = this.commandMap;
        synchronized (map) {
            ArrayList<KscfMulticastReceiveHandler> eventHandlerList = this.commandMap.get(comannd);
            if (eventHandlerList == null) {
                eventHandlerList = new ArrayList<KscfMulticastReceiveHandler>();
                this.commandMap.put(comannd, eventHandlerList);
            }
            eventHandlerList.add(multicastReceiveHandler);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void removeEventHandler(KscfMulticastReceiveHandler multicastReceiveHandler) {
        Map<Integer, ArrayList> map = this.commandMap;
        // MONITORENTER : map
        // MONITOREXIT : map
    }

    public void invokeSingleton1(KscfMulticastData multicastData, Object entity) throws Exception {
        Object[] dataArray = (Object[])entity;
        String className = dataArray[0].toString();
        Object entity2 = dataArray[1];
        Class<?> clazz = Class.forName(className);
        Object targetObj = this.singletonMap.get(className);
        if (targetObj == null) {
            String methodName = "getInstance";
            Class[] paramTypeArray = new Class[0];
            Method method = BcReflectUtil.getMethod(clazz, methodName, paramTypeArray);
            if (method == null) {
                String msg = "not foud :" + clazz.getName() + "." + methodName;
                throw new Exception(msg);
            }
            Object[] paramArray = new Object[]{};
            targetObj = method.invoke(null, paramArray);
            this.singletonMap.put(className, targetObj);
        }
        String methodName = "multicastPacketReceived";
        Method method = this.methodMap.get(String.valueOf(className) + "." + methodName);
        if (method == null) {
            Class[] paramTypeArray = new Class[]{KscfMulticastData.class, Object.class};
            method = BcReflectUtil.getMethod(clazz, methodName, paramTypeArray);
            if (method == null) {
                String msg = "not foud :" + clazz.getName() + "." + methodName;
                throw new Exception(msg);
            }
            this.methodMap.put(String.valueOf(className) + "." + methodName, method);
        }
        Object[] paramArray = new Object[]{multicastData, entity2};
        method.invoke(targetObj, paramArray);
    }
}

