/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf5.fx;

import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.util.BcInputValidator;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxComboBox;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.layout.FxTitledPane;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.table.FxTableRowList;
import jp.co.extreme.fx.table.FxTableUtil;
import jp.co.extreme.fx.table.FxTableView;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.print.DcfPrintCondition;
import jp.co.extreme.print.DcfPrintConditionElement;
import jp.co.extreme.scf5.swg.IswgPrintConditionPanel;
import jp.co.extreme.scf5.swg.IswgPrintConditionTableModel;

public class IfxPrintCondtionPane
extends FxDecoratePane {
    protected FxComboBox printServiceComboBox = new FxComboBox();
    protected FxBorderPane centerPane = new FxBorderPane();
    protected FxFlowPane content1Pane = new FxFlowPane(11);
    protected FxBorderPane content2Pane = new FxBorderPane();
    protected DcfPrintCondition printCondition;
    protected Button button1;
    protected Button button2;
    IswgPrintConditionTableModel tableModel;
    boolean printServiceEnabled;
    String title;
    public boolean completed;
    BcInputValidator inputValidator = BcInputValidator.getInstance();
    protected Stage stage;

    public void setComponent(boolean printServiceEnabled, String title) throws Exception {
        this.printServiceEnabled = printServiceEnabled;
        this.title = title;
        if (this.button1 == null) {
            this.button1 = this.createButton(BcWords.getInstance().completion);
            this.button2 = this.createButton(BcWords.getInstance().cancel);
        }
        this.setCenter((Node)this.centerPane);
        this.centerPane.setTop((Node)this.content1Pane);
        this.centerPane.setCenter((Node)this.content2Pane);
        if (printServiceEnabled) {
            this.content1Pane.setPrefHeight(40.0);
            FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().printService), new Node[]{this.printServiceComboBox});
            this.content1Pane.addNodeUnit(nodeUnit);
        } else {
            this.content1Pane.setPrefHeight(20.0);
        }
        this.underLineEnabled();
        FxUtil.defaultInitialize((Node)this);
    }

    public DcfPrintCondition getPrintCondition() throws Exception {
        return this.printCondition;
    }

    public void setPrintCondition(DcfPrintCondition printCondition) throws Exception {
        this.printCondition = printCondition;
        this.printServiceComboBox.getItems().clear();
        int i = 0;
        while (i < printCondition.printServiceNameList.size()) {
            String printServiceName = printCondition.printServiceNameList.get(i);
            this.printServiceComboBox.getItems().add((Object)printServiceName);
            ++i;
        }
        this.printServiceComboBox.columnCount.set(40);
        FxUtil.setPrefSize((Node)this.printServiceComboBox);
        if (this.printServiceComboBox.getItems().size() > 0) {
            this.printServiceComboBox.getSelectionModel().select(0);
        }
        BcTableColumnModel tableColumnModel = IswgPrintConditionPanel.createTableColumnModel();
        this.tableModel = new IswgPrintConditionTableModel(tableColumnModel);
        InnerTableView tableView = new InnerTableView();
        FxTableUtil.createColumn(tableColumnModel, tableView, null);
        int i2 = 0;
        while (i2 < printCondition.conditionElemetList.size()) {
            DcfPrintConditionElement printConditionElement = printCondition.conditionElemetList.get(i2);
            BcLogUtil.debug("printConditionElement.name=" + printConditionElement.name);
            ++i2;
        }
        this.tableModel.printConditionElementList = printCondition.conditionElemetList;
        FxTableRowList fxTableRowList = new FxTableRowList(this.tableModel);
        tableView.setItems(fxTableRowList);
        tableView.setEditable(true);
        FxTitledPane titledPane1 = new FxTitledPane();
        titledPane1.setTitle(BcWords.getInstance().printStartPosition);
        titledPane1.setContentNode((Node)tableView);
        this.content2Pane.setCenter((Node)titledPane1);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.button1) {
            BcResult result = new BcResult();
            this.printCondition.printServiceName = BcStringUtil.toString(this.printServiceComboBox.getValue());
            if (this.printServiceEnabled) {
                this.inputValidator.notNullable(BcWords.getInstance().printService, this.printCondition.printServiceName, result.getErrorList());
            }
            if (result.hasError()) {
                String msg = BcMessageCreator.getInstance().createMessage(result.getErrorList());
                FxOptionPane.showMessageDialog((Window)this.stage, (Object)msg, BcWords.getInstance().warning, 2);
                return;
            }
            this.completed = true;
            this.close();
        } else if (ev.getSource() == this.button2) {
            this.close();
        }
    }

    public void close() {
        this.stage.close();
    }

    public boolean show(Window ownerWindow) throws Exception {
        if (this.stage != null) {
            FxUtil.showAndToFront(this.stage);
            return this.completed;
        }
        this.completed = false;
        this.stage = new FxStage();
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(780.0);
        this.stage.setHeight(400.0);
        this.stage.setResizable(true);
        if (BcStringUtil.isEmpty(this.title)) {
            this.stage.setTitle(BcWords.getInstance().printSetting);
        } else {
            this.stage.setTitle(this.title);
        }
        FxImageHelper.setStageIcon(this.stage);
        this.stage.showAndWait();
        return this.completed;
    }

    public boolean isShowing() {
        if (this.stage == null) {
            return false;
        }
        return this.stage.isShowing();
    }

    class InnerTableView
    extends FxTableView {
        @Override
        public void rowSelectionChanged(FxTableView tableView, ObservableList<Integer> rowIdList, int prevRowId, int nextRowId) throws Exception {
            super.rowSelectionChanged((FxTableView)this, rowIdList, prevRowId, nextRowId);
        }
    }
}

