/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf.server;

import java.io.File;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.app.common.AfbApplicationSetup;
import jp.co.extreme.app.common.AfbShutdownManager;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.util.BcArgumentUtil;
import jp.co.extreme.base.xml.BcXmlUtil;
import jp.co.extreme.scf.common.ScfConstants;
import jp.co.extreme.scf.rmi.server.RmiServerModule;
import jp.co.extreme.scf.server.ScfServerContainer;
import jp.co.extreme.scf.server.ScfServerShutdownTask;
import jp.co.extreme.scf.util.ScfSetupUtil;
import org.w3c.dom.Document;

public class ScfServerSetup
extends BcLoggableObject
implements AfbApplicationSetup {
    private ScfConstants.RunMode runMode;

    public ScfConstants.RunMode getRunMode() {
        return this.runMode;
    }

    public void setRunMode(ScfConstants.RunMode runMode) {
        this.runMode = runMode;
    }

    @Override
    public void setup(AfbApplication application) throws Exception {
        this.getLogger().debug("ScfServerSetup:runMode=" + (Object)((Object)this.runMode));
        ScfServerContainer serverContainer = ScfServerContainer.getInstance();
        serverContainer.setRunMode(this.runMode);
        if (this.runMode == ScfConstants.RunMode.standAlone) {
            RmiServerModule rmiServerModule = new RmiServerModule();
            rmiServerModule.setInitNo(1);
            rmiServerModule.setStartNo(1);
            rmiServerModule.setEndNo(Integer.MAX_VALUE);
            serverContainer.addModule(rmiServerModule);
        } else {
            String serverCofigPath;
            File file;
            String vFilePath = BcArgumentUtil.getArgumentValue(application.getMainArguments(), ScfConstants.AppArg.serverConfig.value);
            if (BcStringUtil.isEmpty(vFilePath)) {
                vFilePath = "${APP}config/server.xml";
            }
            if ((file = new File(serverCofigPath = application.toReal(vFilePath))).exists()) {
                Document dom = BcXmlUtil.createDocument(file);
                serverContainer.setConfig(dom);
            }
            RmiServerModule rmiServerModule = new RmiServerModule();
            rmiServerModule.setInitNo(1);
            rmiServerModule.setStartNo(1);
            rmiServerModule.setEndNo(Integer.MAX_VALUE);
            serverContainer.addModule(rmiServerModule);
        }
        if (application.getBootConfig() != null) {
            ScfSetupUtil.loadModule(serverContainer, application.getBootConfig(), "serverModule");
        }
        serverContainer.initModule();
        ScfServerShutdownTask serverShutdownTask = new ScfServerShutdownTask();
        AfbShutdownManager.getInstance().addShutdownTask(serverShutdownTask);
    }

    @Override
    public void start(AfbApplication application) throws Exception {
        ScfServerContainer serverContainer = ScfServerContainer.getInstance();
        serverContainer.start();
        this.getLogger().info("Server modules started.");
    }
}

