/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xweb.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcPair;
import jp.co.extreme.css.common.CssBuiler;
import jp.co.extreme.html.common.HtmlBuilder;
import jp.co.extreme.html.common.HtmlConstants;
import jp.co.extreme.html.common.HtmlGlobalAttribute;
import jp.co.extreme.html.common.HtmlTagAttribute;
import jp.co.extreme.lib.html.mdc.MdcConstants;
import jp.co.extreme.lib.html.mdc.MdcCreator;
import jp.co.extreme.module.xweb.common.XwebUtil;

public class XwebLabelAndInputBuilder
extends BcLoggableObject {
    private HtmlBuilder htmlBuilder = HtmlBuilder.getInstance();
    String helperTextSuffux = "__helperText";
    private Outline outlineDefault = Outline.notched;
    private boolean floatingLabel = false;

    public HtmlBuilder getHtmlBuilder() {
        return this.htmlBuilder;
    }

    public String create(HtmlConstants.HtmlInputType inputType, String inputName, int columnCount, int rowCount, boolean disabled, boolean readonly, String label, String value, boolean required, String pattern, String placeholder, String helperText, String script, String errMsg, String autocomplete, boolean characterCounterEnabled, String[] options) throws Exception {
        String sb = null;
        sb = rowCount > 1 ? this.createTextArea(inputName, columnCount, rowCount, disabled, readonly, label, value, required, helperText, script, errMsg) : this.createTextField(inputType, inputName, columnCount, rowCount, disabled, readonly, label, value, required, pattern, placeholder, helperText, script, errMsg, autocomplete, characterCounterEnabled, options);
        return sb;
    }

    public String createTextField(HtmlConstants.HtmlInputType inputType, String inputName, int columnCount, int rowCount, boolean disabled, boolean readonly, String label, String value, boolean required, String pattern, String placeholder, String helperText, String script, String errMsg, String autocomplete, boolean characterCounterEnabled, String[] options) throws Exception {
        String helperTextDiv;
        StringBuilder sb = new StringBuilder();
        if (!this.floatingLabel) {
            sb.append(this.createHeaderLebel(label, readonly, required));
            sb.append(this.getHtmlBuilder().br());
        }
        ArrayList<MdcConstants.MdcClass> divClassList = new ArrayList<MdcConstants.MdcClass>();
        Outline outline = Outline.NULL;
        if (inputType != HtmlConstants.HtmlInputType.date) {
            divClassList.add(MdcConstants.MdcClass.mdc_text_field);
            divClassList.add(MdcConstants.MdcClass.mdc_text_field__dense);
            outline = this.outlineDefault;
        }
        if (outline == Outline.notched) {
            divClassList.add(MdcConstants.MdcClass.mdc_text_field__outlined);
        }
        sb.append(this.getHtmlBuilder().div_start(divClassList));
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        if (inputType != HtmlConstants.HtmlInputType.date) {
            globalAttribute.clazz = MdcCreator.getInstance().text_field__input();
        }
        globalAttribute.id = XwebUtil.toEmenetId(inputName);
        List<HtmlTagAttribute> tagAttributeList1 = this.getHtmlBuilder().toAttributeList(globalAttribute);
        boolean multiple = false;
        String list = XwebUtil.toDataListId(inputName);
        List<HtmlTagAttribute> tagAttributeList2 = this.getHtmlBuilder().toInputAttributeList(inputType.name(), inputName, value, columnCount, columnCount, disabled, readonly, multiple, pattern, placeholder, list, autocomplete);
        tagAttributeList1.addAll(tagAttributeList2);
        String helperTextId = String.valueOf(globalAttribute.id) + this.helperTextSuffux;
        tagAttributeList1.add(new HtmlTagAttribute("aria-controls", helperTextId));
        tagAttributeList1.add(new HtmlTagAttribute("aria-describedby", helperTextId));
        tagAttributeList1.add(new HtmlTagAttribute("autocapitalize", "off"));
        List<HtmlTagAttribute> tagAttributeList3 = this.getTagAttributeList(inputName);
        if (tagAttributeList3 != null) {
            tagAttributeList1.addAll(tagAttributeList3);
        }
        String inputTag = null;
        inputTag = rowCount > 1 ? this.getHtmlBuilder().textArea(globalAttribute, inputName, value, columnCount, rowCount, disabled, readonly, script).toString() : this.getHtmlBuilder().input(tagAttributeList1, script).toString();
        if (inputType == HtmlConstants.HtmlInputType.date) {
            HtmlGlobalAttribute globalAttributeLabel = new HtmlGlobalAttribute();
            globalAttributeLabel.clazz = "date_label";
            sb.append(this.getHtmlBuilder().label_start(globalAttributeLabel, value));
            sb.append(inputTag);
            sb.append(this.getHtmlBuilder().label_end());
        } else {
            sb.append(inputTag);
        }
        if (!BcCollectionUtil.isEmpty(options)) {
            sb.append(this.htmlBuilder.datalist(list, Arrays.asList(options)));
        }
        if (outline == Outline.notched) {
            sb.append(this.getHtmlBuilder().div_start(MdcConstants.MdcClass.mdc_notched_outline.value));
            sb.append(this.getHtmlBuilder().div_start(false, MdcConstants.MdcClass.mdc_notched_outline__leading.value));
            sb.append(this.getHtmlBuilder().div_end());
            sb.append(this.getHtmlBuilder().div_start(MdcConstants.MdcClass.mdc_notched_outline__notch.value));
        }
        if (this.floatingLabel && !BcStringUtil.isEmpty(label)) {
            globalAttribute = new HtmlGlobalAttribute();
            globalAttribute.clazz = MdcConstants.MdcClass.mdc_floating_label.value;
            sb.append(this.getHtmlBuilder().label_start(globalAttribute, inputName));
            sb.append(label);
            sb.append(this.getHtmlBuilder().label_end());
        }
        if (outline == Outline.notched) {
            sb.append(this.getHtmlBuilder().div_end());
            sb.append(this.getHtmlBuilder().div_start(false, MdcConstants.MdcClass.mdc_notched_outline__trailing.value));
            sb.append(this.getHtmlBuilder().div_end());
            sb.append(this.getHtmlBuilder().div_end());
        } else if (outline == Outline.line) {
            sb.append(this.getHtmlBuilder().div_start(false, MdcConstants.MdcClass.mdc_line_ripple.value));
            sb.append(this.getHtmlBuilder().div_end());
        }
        sb.append(this.getHtmlBuilder().div_end());
        if (!readonly && !BcStringUtil.isEmpty(helperTextDiv = this.createHelperTextDiv(helperTextId, helperText, errMsg, characterCounterEnabled))) {
            sb.append(helperTextDiv);
        }
        sb.append(this.getHtmlBuilder().lineSep);
        return sb.toString();
    }

    public String createTextArea(String inputName, int columnCount, int rowCount, boolean disabled, boolean readonly, String label, String value, boolean required, String helperText, String script, String errMsg) throws Exception {
        Boolean characterCounterEnabled;
        String helperTextDiv;
        StringBuilder sb = new StringBuilder();
        if (!this.floatingLabel) {
            sb.append(this.createHeaderLebel(label, readonly, required));
            sb.append(this.getHtmlBuilder().br());
        }
        ArrayList divClassList = new ArrayList();
        sb.append(this.getHtmlBuilder().div_start(divClassList));
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        CssBuiler cssBuiler = new CssBuiler();
        cssBuiler.width("100%");
        globalAttribute.style = cssBuiler.build();
        globalAttribute.id = XwebUtil.toEmenetId(inputName);
        List<HtmlTagAttribute> tagAttributeList1 = this.getHtmlBuilder().toAttributeList(globalAttribute);
        String helperTextId = String.valueOf(globalAttribute.id) + this.helperTextSuffux;
        tagAttributeList1.add(new HtmlTagAttribute("aria-controls", helperTextId));
        tagAttributeList1.add(new HtmlTagAttribute("aria-describedby", helperTextId));
        List<HtmlTagAttribute> tagAttributeList3 = this.getTagAttributeList(inputName);
        if (tagAttributeList3 != null) {
            tagAttributeList1.addAll(tagAttributeList3);
        }
        String textArea = this.getHtmlBuilder().textArea(globalAttribute, inputName, value, columnCount, rowCount, disabled, readonly, script);
        sb.append(textArea);
        sb.append(this.getHtmlBuilder().div_end());
        if (!readonly && !BcStringUtil.isEmpty(helperTextDiv = this.createHelperTextDiv(helperTextId, helperText, errMsg, characterCounterEnabled = Boolean.valueOf(false)))) {
            sb.append(helperTextDiv);
        }
        sb.append(this.getHtmlBuilder().lineSep);
        return sb.toString();
    }

    public String createHeaderLebel(String label, boolean readonly, boolean required) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (!BcStringUtil.isEmpty(label)) {
            CssBuiler cssBuiler = new CssBuiler();
            HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
            globalAttribute.style = cssBuiler.font_size(this.getLabelFontSize()).build();
            sb.append(this.getHtmlBuilder().label_start(globalAttribute, null));
            sb.append(label);
            sb.append(this.getHtmlBuilder().label_end());
        }
        if (!readonly && required) {
            sb.append(XwebUtil.getRequiredBox("0.8rem", "\u5fc5\u9808"));
        }
        return sb.toString();
    }

    public String createHelperTextDiv(String helperTexId, String helperText, String errMsg, boolean characterCounterEnabled) throws Exception {
        HtmlGlobalAttribute globalAttribute;
        boolean isPersistent = true;
        StringBuilder sb1 = new StringBuilder();
        CssBuiler cssBuiler = new CssBuiler();
        if (!BcStringUtil.isEmpty(helperText)) {
            globalAttribute = new HtmlGlobalAttribute();
            globalAttribute.style = cssBuiler.font_size(this.getHintFontSize()).color(HtmlConstants.HtmlColor.gray).build();
            sb1.append((CharSequence)this.getHtmlBuilder().span_start(globalAttribute));
            sb1.append(helperText);
            sb1.append(this.getHtmlBuilder().tagEnd(HtmlConstants.HtmlTag.span, true));
        }
        if (!BcStringUtil.isEmpty(errMsg)) {
            isPersistent = true;
            globalAttribute = new HtmlGlobalAttribute();
            globalAttribute.style = cssBuiler.font_size(this.getHintFontSize()).color(HtmlConstants.HtmlColor.tomato.code).build();
            sb1.append((CharSequence)this.getHtmlBuilder().span_start(globalAttribute));
            sb1.append(errMsg);
            sb1.append(this.getHtmlBuilder().tagEnd(HtmlConstants.HtmlTag.span, true));
        }
        StringBuilder sb2 = new StringBuilder();
        sb2.append(this.getHtmlBuilder().div_start(MdcConstants.MdcClass.mdc_text_field_helper_line.value));
        HtmlGlobalAttribute globalAttribute2 = new HtmlGlobalAttribute();
        globalAttribute2.clazz = isPersistent ? MdcConstants.MdcClass.mdc_text_field_helper_text__persistent.value : MdcConstants.MdcClass.mdc_text_field_helper_text.value;
        globalAttribute2.id = helperTexId;
        List<HtmlTagAttribute> tagAttributeList1 = this.getHtmlBuilder().toAttributeList(globalAttribute2);
        tagAttributeList1.add(new HtmlTagAttribute("aria-hidden", Boolean.toString(true)));
        sb2.append(this.getHtmlBuilder().div_start(tagAttributeList1, true));
        sb2.append((CharSequence)sb1);
        sb2.append(this.getHtmlBuilder().div_end());
        if (characterCounterEnabled) {
            globalAttribute2 = new HtmlGlobalAttribute();
            globalAttribute2.clazz = MdcConstants.MdcClass.mdc_text_field_character_counter.value;
            tagAttributeList1 = this.getHtmlBuilder().toAttributeList(globalAttribute2);
            sb2.append(this.getHtmlBuilder().div_start(tagAttributeList1, false));
            sb2.append("0 / 0");
            sb2.append(this.getHtmlBuilder().div_end());
        }
        sb2.append(this.getHtmlBuilder().div_end());
        sb2.append(this.getHtmlBuilder().lineSep);
        return sb2.toString();
    }

    public List<HtmlTagAttribute> getTagAttributeList(String inputName) throws Exception {
        return null;
    }

    public String getLabelFontSize() throws Exception {
        return "0.9rem";
    }

    public String getHintFontSize() throws Exception {
        return "0.8rem";
    }

    public String createSelect(String inputName, boolean disabled, boolean readonly, String label, String value, boolean required, String helperText, String script, String errMsg, String[] options) throws Exception {
        Boolean characterCounterEnabled;
        String helperTextDiv;
        StringBuilder sb = new StringBuilder();
        if (!this.floatingLabel) {
            sb.append(this.createHeaderLebel(label, readonly, required));
            sb.append(this.getHtmlBuilder().br());
        }
        ArrayList divClassList = new ArrayList();
        sb.append(this.getHtmlBuilder().div_start(divClassList));
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.id = XwebUtil.toEmenetId(inputName);
        List<HtmlTagAttribute> tagAttributeList1 = this.getHtmlBuilder().toAttributeList(globalAttribute);
        String helperTextId = String.valueOf(globalAttribute.id) + this.helperTextSuffux;
        tagAttributeList1.add(new HtmlTagAttribute("aria-controls", helperTextId));
        tagAttributeList1.add(new HtmlTagAttribute("aria-describedby", helperTextId));
        List<HtmlTagAttribute> tagAttributeList3 = this.getTagAttributeList(inputName);
        if (tagAttributeList3 != null) {
            tagAttributeList1.addAll(tagAttributeList3);
        }
        StringBuilder selectTag = new StringBuilder();
        ArrayList<BcPair<String, String>> pairList = new ArrayList<BcPair<String, String>>();
        if (!BcCollectionUtil.isEmpty(options)) {
            String[] stringArray = options;
            int n = options.length;
            int n2 = 0;
            while (n2 < n) {
                String option = stringArray[n2];
                pairList.add(new BcPair<String, String>(option, option));
                ++n2;
            }
        }
        globalAttribute = new HtmlGlobalAttribute();
        selectTag.append(this.getHtmlBuilder().select(globalAttribute, inputName, pairList, value, null));
        sb.append((CharSequence)selectTag);
        sb.append(this.getHtmlBuilder().div_end());
        if (!readonly && !BcStringUtil.isEmpty(helperTextDiv = this.createHelperTextDiv(helperTextId, helperText, errMsg, characterCounterEnabled = Boolean.valueOf(false)))) {
            sb.append(helperTextDiv);
        }
        sb.append(this.getHtmlBuilder().lineSep);
        return sb.toString();
    }

    public static enum Outline {
        NULL,
        notched,
        line;

    }
}

