/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.rmo;

import java.util.HashMap;
import java.util.Map;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.httpserver.HtsvSiteContext;
import jp.co.extreme.json.JacksonUtil;
import jp.co.extreme.module.httpserver.HttpServerController;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.server.XdtsMenuCreator;
import jp.co.extreme.module.xdts.server.XdtsServerUtil;
import jp.co.extreme.module.xdts.server.XdtsUserMenu;
import jp.co.extreme.rmi.common.RmiRemoteMethod;
import jp.co.extreme.rmi.model.RmiRmoArgument;
import jp.co.extreme.rmi.rmo.RmiAbstractRMO;
import jp.co.extreme.scf.server.ScfServerLogger;
import jp.co.extreme.scf.server.ScfServerLoggerManager;
import jp.co.extreme.scf5.dao.ScfAbstractIntPropertyDAO;
import jp.co.extreme.scf5.dao.ZScfPropertyDAOManager;
import jp.co.extreme.scf5.model.ZScfIntProperties;

public class XdtsHttpServerRMO
extends RmiAbstractRMO {
    public void getSiteContext(RmiRmoArgument rmoArg) throws Exception {
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        ScfAbstractIntPropertyDAO propertyDAO2 = ZScfPropertyDAOManager.getInstance().getDao(XdtsConstants.TableName.xdts_property.name());
        ZScfIntProperties intProps = propertyDAO2.getPropertyAsIntProps(dtsSession);
        String jsonStr = intProps.get(XdtsConstants.Property.httpServer.id);
        String dataSourceIdStr = intProps.get(XdtsConstants.Property.dataSourceId.id);
        HashMap<String, String> map = null;
        try {
            map = (HashMap<String, String>)JacksonUtil.getObjectMapper().readValue(jsonStr, Map.class);
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
            map = new HashMap<String, String>();
            map.put(XdtsConstants.Property2.hostName.name(), "localhost");
            map.put(XdtsConstants.Property2.port.name(), "8080");
            map.put(XdtsConstants.Property2.sessionTimeout.name(), Integer.toString(300));
            map.put(XdtsConstants.Property2.siteName.name(), "Database Search Service");
            map.put(XdtsConstants.Property2.resultTimeout.name(), Integer.toString(180));
            jsonStr = JacksonUtil.getObjectMapper().writeValueAsString(map);
        }
        HtsvSiteContext siteContext = new HtsvSiteContext();
        siteContext.propertyMap.put(XdtsConstants.Property.httpServer.name(), jsonStr);
        siteContext.propertyMap.put(XdtsConstants.Property.dataSourceId.name(), dataSourceIdStr);
        rmoArg.getRespons().addData(siteContext);
    }

    public void start(RmiRmoArgument rmoArg) throws Exception {
        HtsvSiteContext siteContext = (HtsvSiteContext)rmoArg.getRequest().getData();
        String loggerHandleId = (String)rmoArg.getRequest().getObject("lhId");
        ScfServerLogger logger = ScfServerLoggerManager.getInstance().getLogger(loggerHandleId);
        String jsonStr = siteContext.propertyMap.get(XdtsConstants.Property.httpServer.name());
        Map map = (Map)JacksonUtil.getObjectMapper().readValue(jsonStr, Map.class);
        String hostName = (String)map.get(XdtsConstants.Property2.hostName.name());
        String tmpStr = (String)map.get(XdtsConstants.Property2.port.name());
        int port = BcNumberUtil.parseInteger(tmpStr, -1);
        tmpStr = (String)map.get(XdtsConstants.Property2.sessionTimeout.name());
        int sessionTimeout = BcNumberUtil.parseInteger(tmpStr, -1);
        siteContext.siteName = (String)map.get(XdtsConstants.Property2.siteName.name());
        String dataSourceIdStr = siteContext.propertyMap.get(XdtsConstants.Property.dataSourceId.name());
        ZScfIntProperties intProps = new ZScfIntProperties();
        intProps.put((Integer)XdtsConstants.Property.httpServer.id, jsonStr);
        intProps.put((Integer)XdtsConstants.Property.dataSourceId.id, dataSourceIdStr);
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        ScfAbstractIntPropertyDAO propertyDAO2 = ZScfPropertyDAOManager.getInstance().getDao(XdtsConstants.TableName.xdts_property.name());
        propertyDAO2.putPropertyElement(dtsSession, intProps);
        dtsSession.commit();
        XdtsMenuCreator.getInstance().setLogger(logger);
        XdtsUserMenu userMenu = XdtsMenuCreator.getInstance().createMenu(dtsSession);
        XdtsMenuCreator.getInstance().setUserMenu(userMenu);
        siteContext.servletPathMap.clear();
        HttpServerController httpServerController = XdtsServerUtil.getInstance().getHttpServerController();
        this.getLogger().debug("httpServerController=" + httpServerController);
        BcResult result = httpServerController.start(siteContext, hostName, port, sessionTimeout);
        rmoArg.getRespons().addData(result);
    }

    public void stop(RmiRmoArgument rmoArg) throws Exception {
        HttpServerController httpServerProcess = XdtsServerUtil.getInstance().getHttpServerController();
        this.getLogger().debug("httpServerProcess=" + httpServerProcess);
        httpServerProcess.stop();
        BcResult result = new BcResult();
        rmoArg.getRespons().addData(result);
    }

    public static enum Method implements RmiRemoteMethod
    {
        getSiteContext,
        start,
        stop;


        @Override
        public String getMethodName() {
            return this.name();
        }
    }
}

